/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooFilenameUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.fugue.Either;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

class SharedTemporaryFiles {
    private static final Logger log = Logger.getLogger(SharedTemporaryFiles.class);
    private static final CacheLoader<? super BambooFileUtils.TemporaryFileSpec, File> loader = new CacheLoader<BambooFileUtils.TemporaryFileSpec, File>(){

        public File load(BambooFileUtils.TemporaryFileSpec data) throws IOException {
            return SharedTemporaryFiles.createTempFile(data);
        }
    };
    private static final RemovalListener<? super BambooFileUtils.TemporaryFileSpec, ? super File> removalListener = new RemovalListener<BambooFileUtils.TemporaryFileSpec, File>(){

        public void onRemoval(RemovalNotification<BambooFileUtils.TemporaryFileSpec, File> removalNotification) {
            ((File)removalNotification.getValue()).delete();
        }
    };
    private static final Cache<BambooFileUtils.TemporaryFileSpec, File> TEMPORARY_FILES = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(removalListener).build(loader);

    private SharedTemporaryFiles() {
    }

    private static File createTempFile(BambooFileUtils.TemporaryFileSpec data) throws IOException {
        String suffix = Integer.toHexString(data.getContentHash());
        if (data.getSuffix() != null) {
            suffix = suffix + data.getSuffix();
        }
        File file = BambooFileUtils.createSafeTempFile(data.getPrefix() + suffix, data.getTemporaryDir());
        FileUtils.writeStringToFile((File)file, (String)data.releaseContent());
        file.setExecutable(data.isExecutable());
        if (!data.is83PathPreferred()) {
            return file;
        }
        Either<String, File> shortWindowsPath = BambooFilenameUtils.getShortWindowsPath(file.getAbsolutePath());
        if (shortWindowsPath.isLeft()) {
            log.warn(shortWindowsPath.left().get());
            return file;
        }
        return (File)shortWindowsPath.right().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(@NotNull BambooFileUtils.TemporaryFileSpec temporaryFileSpec) throws IOException {
        try {
            File file;
            File file2 = file = (File)TEMPORARY_FILES.get((Object)temporaryFileSpec);
            synchronized (file2) {
                if (!file.exists()) {
                    SharedTemporaryFiles.createTempFile(temporaryFileSpec);
                }
            }
            return file;
        }
        catch (ExecutionException e) {
            throw BambooObjectUtils.rethrow(e.getCause(), IOException.class);
        }
    }
}

