/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public class BuildUtils {
    private static final Logger log = Logger.getLogger(BuildUtils.class);
    private static final String unParsedDate = "19:43:05:22012013";
    private static final Date buildDate;
    private static final String buildNumber = "3500";
    private static final String version = "4.4";
    private static final String edition = "";
    private static final boolean devMode = false;
    private static final LazyReference<String> buildNumberRef;

    public static Date getCurrentBuildDate() {
        return buildDate;
    }

    public static String getCurrentBuildNumber() {
        return (String)buildNumberRef.get();
    }

    public static String getCurrentVersion() {
        return version;
    }

    public static String getVersionAndBuild() {
        return "4.4-build-" + BuildUtils.getCurrentBuildNumber();
    }

    public static String getCurrentEdition() {
        return edition;
    }

    public static boolean isDevMode() {
        return false;
    }

    static {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:ddMMyyyy");
        formatter.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        Date parsedDate = null;
        try {
            parsedDate = formatter.parse(unParsedDate);
        }
        catch (ParseException e) {
            log.fatal((Object)"Cannot Parse date: 19:43:05:22012013.  Returning null for date");
        }
        buildDate = parsedDate;
        buildNumberRef = new LazyReference<String>(){

            protected String create() {
                File file;
                if (BuildUtils.isDevMode() && (file = new File("../pom.xml")).exists()) {
                    try {
                        XMLConfiguration xmlConfiguration = new XMLConfiguration(file);
                        return xmlConfiguration.getString("properties.buildNumber");
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                }
                return BuildUtils.buildNumber;
            }
        };
    }
}

