/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.core.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Deprecated
public class BambooXmlUtils {
    private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));
    private static final EntityResolver emptyEntityResolver = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return EMPTY_INPUT_SOURCE;
        }
    };

    private BambooXmlUtils() {
    }

    public static SAXReader newSecureSaxReader() {
        return new SAXReader(BambooXmlUtils.newSecureXmlReader());
    }

    public static DocumentBuilderFactory newSecureDocumentBuilderFactory(@Nullable Logger log) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        BambooXmlUtils.setFeature(log, dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        BambooXmlUtils.setFeature(log, dbf, "http://xml.org/sax/features/external-general-entities", false);
        BambooXmlUtils.setFeature(log, dbf, "http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }

    public static XMLInputFactory newSecureXmlInputFactory() {
        return BambooXmlUtils.configure(XMLInputFactory.newInstance());
    }

    public static XMLInputFactory configure(XMLInputFactory xmlInputFactory) {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlInputFactory;
    }

    public static Digester newSecureDigester() {
        XMLReader reader = BambooXmlUtils.newSecureXmlReader();
        Digester digester = new Digester(reader);
        digester.setEntityResolver(reader.getEntityResolver());
        return digester;
    }

    public static XMLReader newSecureXmlReader() {
        try {
            XMLReader xr = BambooXmlUtils.createSaxParser().getXMLReader();
            xr.setEntityResolver(emptyEntityResolver);
            return xr;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void setFeature(@Nullable Logger log, DocumentBuilderFactory dbf, String name, boolean value) {
        try {
            dbf.setFeature(name, value);
        }
        catch (ParserConfigurationException e) {
            if (log != null) {
                log.warn((Object)("Unable to set " + name + " to " + value));
            }
            throw new UnsupportedOperationException(e);
        }
    }

    private static SAXParser createSaxParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return spf.newSAXParser();
    }

    @NotNull
    public static String sanitiseXml10(@NotNull String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (XMLUtils.validXml((char)value.charAt(i))) continue;
            return BambooXmlUtils.sanitiseFrom(value, i);
        }
        return value;
    }

    @NotNull
    private static String sanitiseFrom(@NotNull String value, int firstInvalidChar) {
        StringBuilder sb = new StringBuilder(value.substring(0, firstInvalidChar));
        int len = value.length();
        for (int i = firstInvalidChar + 1; i < len; ++i) {
            char ch = value.charAt(i);
            if (!XMLUtils.validXml((char)ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

