/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.DoubleThrowingPredicate;
import com.atlassian.bamboo.util.ThrowingPredicate;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BambooIterables {
    private BambooIterables() {
    }

    @Nullable
    public static <T, E extends Throwable> T find(Iterable<T> iterable, ThrowingPredicate<? super T, E> predicate, @Nullable T defaultValue) throws E {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    @Nullable
    public static <T, E extends Throwable, F extends Throwable> T find(Iterable<T> iterable, DoubleThrowingPredicate<? super T, E, F> predicate, @Nullable T defaultValue) throws E, F {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    public <T> boolean none(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return !Iterables.any(iterable, predicate);
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate, @Nullable String exceptionMessage) {
        try {
            return (T)Iterables.find(iterable, predicate);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(exceptionMessage);
        }
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable, T object) {
        return Iterables.concat(iterable, Collections.singletonList(object));
    }

    public static <T> Pair<Iterable<T>, Iterable<T>> split(List<T> unfiltered, Predicate<T> predicate) {
        return Pair.make(Iterables.filter(unfiltered, predicate), Iterables.filter(unfiltered, (Predicate)Predicates.not(predicate)));
    }
}

