/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BranchSpecificConfiguration
implements OptionallyConvertibleFromConfig {
    private static final Logger log = Logger.getLogger(BranchSpecificConfiguration.class);
    public static final String BRANCH_CLEANUP_DISABLED = "branchConfiguration.cleanup.disabled";
    @Deprecated
    public static final String BRANCH_OVERRIDE_BUILD_STRATEGY = "branchConfiguration.buildStrategy.override";
    @Deprecated
    public static final String BRANCH_TRIGGER_REPOSITORIES = "branchConfiguration.buildStrategy.triggerRepositories";
    public static final String BRANCH_NOTIFICATION_STRATEGY = "branchConfiguration.notificationStrategy";
    private boolean isValid;
    private boolean branchCleanupDisabled;
    private BranchNotificationStrategy notificationStrategy = BranchNotificationStrategy.NOTIFY_COMMITTERS;

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey(BRANCH_CLEANUP_DISABLED) || config.containsKey(BRANCH_NOTIFICATION_STRATEGY);
        this.branchCleanupDisabled = config.getBoolean(BRANCH_CLEANUP_DISABLED, false);
        this.setNotificationStrategy(BranchNotificationStrategy.fromKey(config.getString(BRANCH_NOTIFICATION_STRATEGY, BranchNotificationStrategy.NOTIFY_COMMITTERS.getKey())));
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.addProperty(BRANCH_CLEANUP_DISABLED, (Object)this.branchCleanupDisabled);
        config.setProperty(BRANCH_NOTIFICATION_STRATEGY, (Object)this.notificationStrategy.getKey());
        return config;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean isBranchCleanupDisabled() {
        return this.branchCleanupDisabled;
    }

    public void setBranchCleanupDisabled(boolean branchCleanupDisabled) {
        this.branchCleanupDisabled = branchCleanupDisabled;
    }

    public BranchNotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    public void setNotificationStrategy(BranchNotificationStrategy notificationStrategy) {
        this.notificationStrategy = notificationStrategy;
    }
}

