/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SharedTemporaryFiles {
    private static final CacheLoader<? super TemporaryFileData, File> loader = new CacheLoader<TemporaryFileData, File>(){

        public File load(TemporaryFileData data) throws IOException {
            return SharedTemporaryFiles.createTempFile(data);
        }
    };
    private static final RemovalListener<? super TemporaryFileData, ? super File> removalListener = new RemovalListener<TemporaryFileData, File>(){

        public void onRemoval(RemovalNotification<TemporaryFileData, File> removalNotification) {
            ((File)removalNotification.getValue()).delete();
        }
    };
    private static final Cache<TemporaryFileData, File> TEMPORARY_FILES = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(removalListener).build(loader);

    private SharedTemporaryFiles() {
    }

    private static File createTempFile(TemporaryFileData data) throws IOException {
        String suffix = Integer.toHexString(data.getContentHash());
        if (data.getSuffix() != null) {
            suffix = suffix + data.getSuffix();
        }
        File file = BambooFileUtils.createSafeTempFile(data.getPrefix() + suffix, data.getTemporaryDir());
        FileUtils.writeStringToFile((File)file, (String)data.releaseContent());
        file.setExecutable(data.isExecutable());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFile(@NotNull String content, @NotNull String prefix, @Nullable String suffix, boolean executable, @Nullable File directory) throws IOException {
        try {
            File file;
            TemporaryFileData temporaryFileData = new TemporaryFileData(content, prefix, suffix, executable, directory);
            File file2 = file = (File)TEMPORARY_FILES.get((Object)temporaryFileData);
            synchronized (file2) {
                if (!file.exists()) {
                    SharedTemporaryFiles.createTempFile(temporaryFileData);
                }
            }
            return file;
        }
        catch (ExecutionException e) {
            throw BambooObjectUtils.rethrow(e.getCause(), IOException.class);
        }
    }

    private static class TemporaryFileData {
        private final String prefix;
        private final int contentHash;
        private String content;
        private final String suffix;
        private final boolean executable;
        private final File temporaryDir;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemporaryFileData that = (TemporaryFileData)o;
            if (this.contentHash != that.contentHash) {
                return false;
            }
            if (this.executable != that.executable) {
                return false;
            }
            if (!this.prefix.equals(that.prefix)) {
                return false;
            }
            if (this.suffix != null ? !this.suffix.equals(that.suffix) : that.suffix != null) {
                return false;
            }
            return !(this.temporaryDir != null ? !this.temporaryDir.equals(that.temporaryDir) : that.temporaryDir != null);
        }

        public int hashCode() {
            int result = this.prefix.hashCode();
            result = 31 * result + this.contentHash;
            result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
            result = 31 * result + (this.executable ? 1 : 0);
            result = 31 * result + (this.temporaryDir != null ? this.temporaryDir.hashCode() : 0);
            return result;
        }

        public TemporaryFileData(@NotNull String content, @NotNull String prefix, @Nullable String suffix, boolean executable, @Nullable File temporaryDir) {
            this.prefix = prefix;
            this.content = content;
            this.suffix = suffix;
            this.executable = executable;
            this.temporaryDir = temporaryDir;
            this.contentHash = this.content.hashCode();
        }

        @NotNull
        public String getPrefix() {
            return this.prefix;
        }

        @Nullable
        public String getSuffix() {
            return this.suffix;
        }

        public int getContentHash() {
            return this.contentHash;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public String releaseContent() {
            String content = this.content;
            this.content = null;
            return content;
        }

        @Nullable
        public File getTemporaryDir() {
            return this.temporaryDir;
        }
    }
}

