/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RerunBuildTriggerReason
extends ManualBuildTriggerReason
implements TriggerReason {
    private static final Logger log = Logger.getLogger(RerunBuildTriggerReason.class);
    public static final String KEY = "com.atlassian.bamboo.plugin.system.triggerReason:RerunBuildTriggerReason";
    public static final String NUMBER_OF_RETRIES = "RerunBuildTriggerReason.noOfRetries";
    private Integer numberOfRetries;

    @Override
    public String getName() {
        return "Rerun build";
    }

    @Override
    public String getNameForSentence() {
        return TextProviderUtils.getHtml(this.textProvider, "build.triggerreason.rerunBuild", this.getUserName());
    }

    @Override
    public void init(String key, Map<String, String> fields) {
        super.init(key, fields);
        String numberOfRetriesString = Narrow.to(fields.get(NUMBER_OF_RETRIES), String.class);
        if (!StringUtils.isBlank((String)numberOfRetriesString)) {
            this.numberOfRetries = Integer.parseInt(numberOfRetriesString);
        }
    }

    @Override
    public void init(String key, @NotNull ResultsSummary resultsSummary) {
        this.init(key, resultsSummary.getCustomBuildData());
    }

    @Override
    public void updateBuildResultsSummary(ResultsSummary resultsSummary) {
        super.updateBuildResultsSummary(resultsSummary);
        if (resultsSummary != null && this.getNumberOfRetries() != null) {
            resultsSummary.getCustomBuildData().put(NUMBER_OF_RETRIES, Integer.toString(this.getNumberOfRetries()));
        }
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }
}

