/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.fage;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Either;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class Result<E extends Throwable, T> {
    private final Either<E, T> result;

    Result(@NotNull T result) {
        this.result = Either.right(result);
    }

    Result(@NotNull E exception) {
        this.result = Either.left(exception);
    }

    public boolean hasException() {
        return this.result.isLeft();
    }

    public T getResult() {
        return (T)this.result.right().get();
    }

    @Nullable
    public T getResult(@Nullable T defaultValue) {
        return this.hasException() ? defaultValue : this.getResult();
    }

    public E getException() {
        return (E)((Throwable)this.result.left().get());
    }

    public T getResultThrowException() throws E {
        if (this.hasException()) {
            throw this.getException();
        }
        return this.getResult();
    }

    public static <E extends Throwable, T> Result<E, T> result(T result) {
        return new Result<Object, T>(Preconditions.checkNotNull(result));
    }

    public static <E extends Throwable, T> Result<E, T> exception(E exception) {
        return new Result<Throwable, T>((Throwable)Preconditions.checkNotNull(exception));
    }
}

