/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooIOUtils;
import com.atlassian.bamboo.util.SharedTemporaryFiles;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooFileUtils {
    private static final Logger log = Logger.getLogger(BambooFileUtils.class);

    private BambooFileUtils() {
    }

    public static boolean isDirectoryImportant(File planSourceDirectory) {
        if (planSourceDirectory == null || planSourceDirectory.getAbsolutePath() == null) {
            return false;
        }
        String path = planSourceDirectory.getAbsolutePath();
        return path.equals("/") || path.equals("/tmp") || path.equals("C:\\tmp") || path.equals("C:") || path.equals("C:\\") || path.equals("C:\\Windows\\system32") || path.equals("C:\\Windows") || path.equals(System.getProperty("user.home")) || path.equals(new File("").getAbsolutePath());
    }

    public static File createTempDirectory(@NotNull Object client) throws IOException {
        return BambooFileUtils.createTempDirectory(client.getClass().getName());
    }

    public static File createTempDirectory(@Nullable File parentDir, @NotNull String prefix) throws IOException {
        int MAX_TRIES = 10;
        int tries = 0;
        while (tries < 10) {
            File tempDirectory = File.createTempFile(prefix, null, parentDir);
            if (tempDirectory.delete() && tempDirectory.mkdir()) {
                return tempDirectory;
            }
            if (tries++ > 5 && tries < 10) {
                try {
                    Thread.sleep(10 + 2 * tries);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            log.warn((Object)String.format("Could not replace temporary file %s with a directory (attempt %d)", tempDirectory.getAbsolutePath(), tries));
        }
        throw new IOException("Could not replace temporary file with a directory.");
    }

    public static File createTempDirectory(@NotNull String prefix) throws IOException {
        return BambooFileUtils.createTempDirectory(null, prefix);
    }

    @NotNull
    protected static File openSafeTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix, directory);
        BambooFileUtils.setReadableByOwnerOnly(tempFile);
        BambooFileUtils.setWritableByOwnerOnly(tempFile);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static File createSafeTempFile(@NotNull String name, @Nullable File dir) throws IOException {
        boolean isDeleted;
        File tempFile;
        if (dir == null) {
            dir = SystemUtils.getJavaIoTmpDir();
        }
        if ((tempFile = new File(dir, name)).exists() && !(isDeleted = tempFile.delete())) {
            throw new IOException("Unable to delete already existing file: " + tempFile);
        }
        BambooFileUtils.setReadableByOwnerOnly(tempFile);
        BambooFileUtils.setWritableByOwnerOnly(tempFile);
        boolean isCreated = tempFile.createNewFile();
        if (!isCreated) {
            throw new IOException("Could not create file: " + tempFile);
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static boolean setWritableByOwnerOnly(File file) {
        boolean nobodyWrites = file.setWritable(false, false);
        boolean ownerWrites = file.setWritable(true, true);
        return nobodyWrites && ownerWrites;
    }

    public static boolean setReadableByOwnerOnly(File file) {
        boolean nobodyReads = file.setReadable(false, false);
        boolean ownerReads = file.setReadable(true, true);
        return nobodyReads && ownerReads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static File safeWriteStringToFile(@NotNull String string, @NotNull String prefix, @Nullable String suffix, @Nullable File directory) throws IOException {
        File createdTmpFile = BambooFileUtils.openSafeTempFile(prefix, suffix, directory);
        FileOutputStream fos = new FileOutputStream(createdTmpFile);
        try {
            File openedTmpFile = new File(createdTmpFile.getCanonicalPath());
            boolean chmodSuccessful = BambooFileUtils.canChangePermissions(openedTmpFile);
            if (!chmodSuccessful) {
                throw new SecurityException("Unable to set ownership on file: " + openedTmpFile);
            }
            IOUtils.write((String)string, (OutputStream)fos);
        }
        finally {
            fos.close();
        }
        return createdTmpFile;
    }

    private static boolean canChangePermissions(File file) {
        boolean ownerCannotWrite = file.setWritable(false, true);
        boolean ownerCanWrite = file.setWritable(true, true);
        return ownerCannotWrite && ownerCanWrite;
    }

    @NotNull
    public static List<String> splitPathToComponents(@NotNull String path) {
        ArrayList result = Lists.newArrayList();
        File file = new File(path);
        do {
            result.add(0, file.getName());
        } while ((file = file.getParentFile()) != null);
        return result;
    }

    @NotNull
    public static String pathFromComponents(String ... pathComponents) {
        File file = new File("");
        for (String pathComponent : pathComponents) {
            file = new File(file, pathComponent);
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(File file, Pattern pattern) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        CharsetDecoder decoder = BambooIOUtils.UTF_8_CHARSET.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, decoder);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            br.close();
        }
        return false;
    }

    public static boolean containsRegex(@NotNull File file, @NotNull String regexToMatch) throws IOException {
        Pattern pattern = Pattern.compile(regexToMatch);
        return BambooFileUtils.contains(file, pattern);
    }

    public static String relativizePath(@NotNull File rootDirectory, @NotNull File workingDirectory, @Nullable String path) {
        if (path != null) {
            return workingDirectory.toURI().relativize(new File(rootDirectory, path).toURI()).getPath();
        }
        return path;
    }

    public static void renameTo(File from, File to) throws IOException {
        if (from.isDirectory()) {
            FileUtils.moveDirectory((File)from, (File)to);
        } else {
            FileUtils.moveFile((File)from, (File)to);
        }
    }

    public static void moveDirectoryContentToDirectory(@NotNull File src, @NotNull File destDir, boolean createDestDir) throws IOException {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)destDir);
        if (!src.isDirectory()) {
            throw new IOException(src + " is not a directory");
        }
        if (!destDir.exists() && createDestDir && !destDir.mkdirs()) {
            throw new IOException("Unable to create " + destDir);
        }
        File[] files = src.listFiles();
        if (files != null) {
            for (File file : files) {
                FileUtils.moveToDirectory((File)file, (File)destDir, (boolean)false);
            }
        }
    }

    public static File getSharedTemporaryFile(@NotNull String content, @NotNull String prefix, @Nullable String suffix, boolean executable, @Nullable File directory) throws IOException {
        return SharedTemporaryFiles.getFile(content, prefix, suffix, executable, directory);
    }

    @Nullable
    public static File safeNewFile(@Nullable String path) {
        return path != null ? new File(path) : null;
    }
}

