/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.acegi.acls;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.acegisecurity.acls.AclFormattingUtils;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.CumulativePermission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.Assert;

public class BambooPermission
implements Permission {
    private static final Logger log;
    public static final String READ_STR = "READ";
    public static final String WRITE_STR = "WRITE";
    private static final String CREATE_STR = "CREATE";
    private static final String DELETE_STR = "DELETE";
    public static final String ADMINISTRATION_STR = "ADMINISTRATION";
    private static final String SIGN_UP_STR = "SIGN_UP";
    private static final String BUILD_STR = "BUILD";
    private static final String CLONE_STR = "CLONE";
    public static final String RESTRICTED_ADMINISTRATION_STR = "RESTRICTEDADMINISTRATION";
    public static final BambooPermission READ;
    public static final BambooPermission WRITE;
    public static final BambooPermission CREATE;
    public static final BambooPermission DELETE;
    public static final BambooPermission ADMINISTRATION;
    public static final BambooPermission SIGN_UP;
    public static final BambooPermission BUILD;
    public static final BambooPermission CLONE;
    public static final BambooPermission RESTRICTEDADMINISTRATION;
    private static final ImmutableList<BambooPermission> DETAILED_PLAN_PERMISSIONS;
    public static final ImmutableList<BambooPermission> PLAN_RELATED_PERMISSIONS;
    public static final ImmutableSet<Permission> RESTRICTED_ADMIN_PERMISSIONS;
    @Deprecated
    public static final ImmutableSet<String> RESTRICTED_ADMIN_PERMISSION_NAMES;
    private static final ImmutableMap<Integer, BambooPermission> MASK_TO_PERMISSION;
    private static final ImmutableMap<String, BambooPermission> NAME_TO_PERMISSION;
    private final char code;
    private final int mask;
    private final String name;

    @Nullable
    public static String determineNameFromPermission(Permission permission) {
        switch (permission.getMask()) {
            case 1: {
                return READ_STR;
            }
            case 2: {
                return WRITE_STR;
            }
            case 4: {
                return CREATE_STR;
            }
            case 8: {
                return DELETE_STR;
            }
            case 16: {
                return ADMINISTRATION_STR;
            }
            case 32: {
                return SIGN_UP_STR;
            }
            case 64: {
                return BUILD_STR;
            }
            case 128: {
                return CLONE_STR;
            }
            case 256: {
                return RESTRICTED_ADMINISTRATION_STR;
            }
        }
        return null;
    }

    private BambooPermission(int mask, char code, String name) {
        this.mask = mask;
        this.code = code;
        this.name = name;
    }

    @Deprecated
    @NotNull
    public static Permission[] getPlanPermissions() {
        return (Permission[])PLAN_RELATED_PERMISSIONS.toArray((Object[])new Permission[PLAN_RELATED_PERMISSIONS.size()]);
    }

    @NotNull
    public static ImmutableList<BambooPermission> getPlanPermissionsList() {
        return PLAN_RELATED_PERMISSIONS;
    }

    public static Permission buildFromMask(int mask) {
        if (MASK_TO_PERMISSION.containsKey((Object)mask)) {
            return (Permission)MASK_TO_PERMISSION.get((Object)mask);
        }
        CumulativePermission permission = new CumulativePermission();
        for (int i = 0; i < 32; ++i) {
            int permissionToCheck = 1 << i;
            if ((mask & permissionToCheck) != permissionToCheck) continue;
            Permission p = (Permission)MASK_TO_PERMISSION.get((Object)permissionToCheck);
            Assert.state((p != null ? 1 : 0) != 0, (String)("Mask " + permissionToCheck + " does not have a corresponding static BambooPermission"));
            permission.set(p);
        }
        return permission;
    }

    public static Permission[] buildFromMask(int[] inputMasks) {
        if (inputMasks == null || inputMasks.length == 0) {
            return new Permission[0];
        }
        ArrayList list = Lists.newArrayList();
        for (int mask : inputMasks) {
            list.add(BambooPermission.buildFromMask(mask));
        }
        return list.toArray(new Permission[list.size()]);
    }

    @NotNull
    public static Permission buildFromName(String name) {
        BambooPermission bambooPermission = (BambooPermission)NAME_TO_PERMISSION.get((Object)name);
        Assert.isTrue((bambooPermission != null ? 1 : 0) != 0, (String)("Unknown permission '" + name + "'"));
        return bambooPermission;
    }

    public static Permission[] buildFromName(String[] names) {
        if (names == null || names.length == 0) {
            return new Permission[0];
        }
        ArrayList list = Lists.newArrayList();
        for (String name : names) {
            list.add(BambooPermission.buildFromName(name));
        }
        return list.toArray(new Permission[list.size()]);
    }

    @Deprecated
    public static boolean isGrantedForRestrictedAdmin(String permission) {
        return RESTRICTED_ADMIN_PERMISSION_NAMES.contains((Object)permission);
    }

    public static boolean isGrantedForRestrictedAdmin(Permission permission) {
        return RESTRICTED_ADMIN_PERMISSIONS.contains((Object)permission);
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof BambooPermission)) {
            return false;
        }
        BambooPermission rhs = (BambooPermission)arg0;
        return this.mask == rhs.getMask();
    }

    public int getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return AclFormattingUtils.printBinary((int)this.mask, (char)this.code);
    }

    public String toString() {
        return "BambooPermission[" + this.getPattern() + "=" + this.mask + "]";
    }

    static {
        Field[] fields;
        log = Logger.getLogger(BambooPermission.class);
        READ = new BambooPermission(1, 'R', READ_STR);
        WRITE = new BambooPermission(2, 'W', WRITE_STR);
        CREATE = new BambooPermission(4, 'C', CREATE_STR);
        DELETE = new BambooPermission(8, 'D', DELETE_STR);
        ADMINISTRATION = new BambooPermission(16, 'A', ADMINISTRATION_STR);
        SIGN_UP = new BambooPermission(32, 'S', SIGN_UP_STR);
        BUILD = new BambooPermission(64, 'B', BUILD_STR);
        CLONE = new BambooPermission(128, 'O', CLONE_STR);
        RESTRICTEDADMINISTRATION = new BambooPermission(256, 'X', RESTRICTED_ADMINISTRATION_STR);
        DETAILED_PLAN_PERMISSIONS = ImmutableList.of((Object)READ, (Object)WRITE, (Object)CREATE, (Object)DELETE, (Object)BUILD, (Object)CLONE);
        PLAN_RELATED_PERMISSIONS = ImmutableList.builder().addAll(DETAILED_PLAN_PERMISSIONS).add((Object)ADMINISTRATION).build();
        RESTRICTED_ADMIN_PERMISSIONS = ImmutableSet.copyOf(DETAILED_PLAN_PERMISSIONS);
        RESTRICTED_ADMIN_PERMISSION_NAMES = ImmutableSet.copyOf((Iterable)Iterables.transform(DETAILED_PLAN_PERMISSIONS, (Function)new Function<BambooPermission, String>(){

            public String apply(@Nullable BambooPermission input) {
                assert (input != null);
                return input.getName();
            }
        }));
        ImmutableMap.Builder maskToPermissionBuilder = ImmutableMap.builder();
        ImmutableMap.Builder nameToPermissionBuilder = ImmutableMap.builder();
        for (Field field : fields = BambooPermission.class.getDeclaredFields()) {
            try {
                Object fieldValue = field.get(null);
                if (!BambooPermission.class.isAssignableFrom(fieldValue.getClass())) continue;
                BambooPermission perm = (BambooPermission)fieldValue;
                maskToPermissionBuilder.put((Object)perm.getMask(), (Object)perm);
                nameToPermissionBuilder.put((Object)field.getName(), (Object)perm);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        MASK_TO_PERMISSION = maskToPermissionBuilder.build();
        NAME_TO_PERMISSION = nameToPermissionBuilder.build();
    }
}

