/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger.interceptors;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class ContentMatchingInterceptor
implements LogInterceptor {
    private static final Logger log = Logger.getLogger(ContentMatchingInterceptor.class);
    protected final String stringToMatch;
    private final boolean matchErrorMessages;
    private int matchAge;
    private LogEntry match;

    public ContentMatchingInterceptor(String stringToMatch, boolean matchErrorMessages) {
        this.stringToMatch = stringToMatch;
        this.matchErrorMessages = matchErrorMessages;
    }

    @Override
    public void intercept(@NotNull LogEntry logEntry) {
        this.interceptAny(logEntry);
    }

    @Override
    public void interceptError(@NotNull LogEntry logEntry) {
        if (this.matchErrorMessages) {
            this.interceptAny(logEntry);
        }
    }

    private void interceptAny(LogEntry logEntry) {
        if (this.match != null) {
            ++this.matchAge;
        }
        if (this.matches(logEntry)) {
            this.match = logEntry;
            this.matchAge = 0;
        }
    }

    protected abstract boolean matches(LogEntry var1);

    public boolean hasMatched() {
        return this.match != null;
    }

    public int getMatchAge() {
        return this.matchAge;
    }

    public boolean isMatchRecentEnough(int maximumAge) {
        return this.hasMatched() && (maximumAge == -1 || this.matchAge < maximumAge);
    }

    public String getStringToMatch() {
        return this.stringToMatch;
    }
}

