/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BranchSpecificConfiguration
implements OptionallyConvertibleFromConfig {
    private static final Logger log = Logger.getLogger(BranchSpecificConfiguration.class);
    public static final String BRANCH_CLEANUP_DISABLED = "branchConfiguration.cleanup.disabled";
    private static final String BRANCH_OVERRIDE_BUILD_STRATEGY = "branchConfiguration.buildStrategy.override";
    private static final String BRANCH_TRIGGER_REPOSITORIES = "branchConfiguration.buildStrategy.triggerRepositories";
    public static final String BRANCH_NOTIFICATION_STRATEGY = "branchConfiguration.notificationStrategy";
    private boolean isValid;
    private boolean branchCleanupDisabled;
    private boolean overrideBuildStrategy;
    private Set<Long> triggerRepositories = Sets.newHashSet();
    private BranchNotificationStrategy notificationStrategy = BranchNotificationStrategy.NOTIFY_COMMITTERS;

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey(BRANCH_CLEANUP_DISABLED) || config.containsKey(BRANCH_OVERRIDE_BUILD_STRATEGY) || config.containsKey(BRANCH_NOTIFICATION_STRATEGY);
        this.branchCleanupDisabled = config.getBoolean(BRANCH_CLEANUP_DISABLED, false);
        this.overrideBuildStrategy = config.getBoolean(BRANCH_OVERRIDE_BUILD_STRATEGY, false);
        this.triggerRepositories = Sets.newHashSet();
        if (config.containsKey(BRANCH_TRIGGER_REPOSITORIES)) {
            String triggerRepositoriesString = config.getString(BRANCH_TRIGGER_REPOSITORIES);
            Iterables.addAll(this.triggerRepositories, (Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)triggerRepositoriesString), (Function)new Function<String, Long>(){

                public Long apply(String input) {
                    return StringUtils.isEmpty((String)input) ? null : Long.valueOf(Long.parseLong(input));
                }
            }), (Predicate)Predicates.notNull()));
        }
        this.setNotificationStrategy(BranchNotificationStrategy.fromKey(config.getString(BRANCH_NOTIFICATION_STRATEGY, BranchNotificationStrategy.NOTIFY_COMMITTERS.getKey())));
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.addProperty(BRANCH_CLEANUP_DISABLED, (Object)this.branchCleanupDisabled);
        config.addProperty(BRANCH_OVERRIDE_BUILD_STRATEGY, (Object)this.overrideBuildStrategy);
        config.addProperty(BRANCH_TRIGGER_REPOSITORIES, (Object)Joiner.on((String)",").join(this.triggerRepositories));
        config.setProperty(BRANCH_NOTIFICATION_STRATEGY, (Object)this.notificationStrategy.getKey());
        return config;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean isBranchCleanupDisabled() {
        return this.branchCleanupDisabled;
    }

    public void setBranchCleanupDisabled(boolean branchCleanupDisabled) {
        this.branchCleanupDisabled = branchCleanupDisabled;
    }

    public boolean isOverrideBuildStrategy() {
        return this.overrideBuildStrategy;
    }

    public void setOverrideBuildStrategy(boolean overrideBuildStrategy) {
        this.overrideBuildStrategy = overrideBuildStrategy;
    }

    public Set<Long> getTriggerRepositories() {
        return this.triggerRepositories;
    }

    public void setTriggerRepositories(Set<Long> triggerRepositories) {
        this.triggerRepositories = triggerRepositories;
    }

    public BranchNotificationStrategy getNotificationStrategy() {
        return this.notificationStrategy;
    }

    public void setNotificationStrategy(BranchNotificationStrategy notificationStrategy) {
        this.notificationStrategy = notificationStrategy;
    }
}

