/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

@Internal
public enum PlanType {
    CHAIN(Chain.class),
    JOB(Job.class),
    CHAIN_BRANCH(ChainBranch.class);

    private final Class<? extends ImmutablePlan> aClass;
    private final boolean isChain;
    private final boolean isBuildable;
    private static final EnumSet<PlanType> chainPlanTypes;

    private PlanType(Class<? extends Plan> aClass) {
        this.aClass = aClass;
        this.isChain = Chain.class.isAssignableFrom(aClass);
        this.isBuildable = Buildable.class.isAssignableFrom(aClass);
    }

    public Class<? extends ImmutablePlan> getClassType() {
        return this.aClass;
    }

    public boolean isChain() {
        return this.isChain;
    }

    public boolean isBuildable() {
        return this.isBuildable;
    }

    @NotNull
    public static EnumSet<PlanType> getChainPlanTypes() {
        return chainPlanTypes;
    }

    static {
        chainPlanTypes = Sets.newEnumSet((Iterable)Iterables.filter(Arrays.asList(PlanType.values()), (Predicate)new Predicate<PlanType>(){

            public boolean apply(PlanType input) {
                return input.isChain();
            }
        }), PlanType.class);
    }
}

