/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.configuration.CaptchaConfiguration;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.security.trustedapplications.BambooCurrentApplication;
import com.atlassian.bamboo.util.UrlUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class AdministrationConfiguration
implements Serializable {
    private static final Logger log = Logger.getLogger(AdministrationConfiguration.class);
    public static final String DEFAULT_URL = "http://localhost:8085";
    public static final int DEFAULT_BUILD_IN_QUEUE_TIMEOUT = 120;
    private String myBaseUrl = "http://localhost:8085";
    private boolean myUseGzipCompression = true;
    private String myInstanceName;
    private BuildExpiryConfig myBuildExpiryConfiguration;
    private BuildHangingConfig myBuildHangingConfig;
    private ElasticConfiguration elasticConfig;
    private ConcurrentBuildConfig concurrentBuildConfig;
    private boolean enableSignup = true;
    private boolean enableAnonymousAccess = true;
    private boolean enableExternalUserManagement = false;
    private boolean enableViewContactDetails = false;
    private boolean enableRestrictedAdmin = false;
    private boolean remoteAgentFunctionEnabled = false;
    private boolean remoteAgentAuthenticationEnabled = false;
    private boolean auditLoggingEnabled = false;
    private boolean gravatarSupportEnabled = true;
    private BambooCurrentApplication currentApplication;
    private CaptchaConfiguration captchaConfiguration;
    private ScheduleBackupConfiguration scheduleBackupConfiguration;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> globalVariables = new HashMap<String, String>();
    private int buildHangedInQueueNotificationTimeout = 120;
    private RepositorySettings repositorySettings;
    private Map<String, String> artifactHandlerConfiguration;

    public String getBaseUrl() {
        return UrlUtils.correctlyFormatUrl(this.myBaseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        this.myBaseUrl = baseUrl;
    }

    public boolean isUseGzipCompression() {
        return this.myUseGzipCompression;
    }

    public void setUseGzipCompression(boolean useGzipCompression) {
        this.myUseGzipCompression = useGzipCompression;
    }

    public boolean isEnableSignup() {
        return this.enableSignup;
    }

    public void setEnableSignup(boolean enableSignup) {
        this.enableSignup = enableSignup;
    }

    public boolean isEnableAnonymousAccess() {
        return this.enableAnonymousAccess;
    }

    public void setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    public boolean isEnableExternalUserManagement() {
        return this.enableExternalUserManagement;
    }

    public CaptchaConfiguration getCaptchaConfiguration() {
        if (this.captchaConfiguration == null) {
            this.captchaConfiguration = new CaptchaConfiguration();
        }
        return this.captchaConfiguration;
    }

    public void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this.captchaConfiguration = captchaConfiguration;
    }

    @Nullable
    public BambooCurrentApplication getCurrentApplication() {
        return this.currentApplication;
    }

    public void setCurrentApplication(BambooCurrentApplication currentApplication) {
        this.currentApplication = currentApplication;
    }

    @NotNull
    public ConcurrentBuildConfig getConcurrentBuildConfig() {
        if (this.concurrentBuildConfig == null) {
            this.concurrentBuildConfig = new ConcurrentBuildConfig();
        }
        return this.concurrentBuildConfig;
    }

    public void setConcurrentBuildConfig(ConcurrentBuildConfig concurrentBuildConfig) {
        this.concurrentBuildConfig = concurrentBuildConfig;
    }

    public void setEnableExternalUserManagement(boolean enableExternalUserManagement) {
        this.enableExternalUserManagement = enableExternalUserManagement;
    }

    public boolean isEnableViewContactDetails() {
        return this.enableViewContactDetails;
    }

    public void setEnableViewContactDetails(boolean enableViewContactDetails) {
        this.enableViewContactDetails = enableViewContactDetails;
    }

    public void setBuildExpiryConfig(BuildExpiryConfig buildExpiryConfig) {
        this.myBuildExpiryConfiguration = buildExpiryConfig;
    }

    public BuildExpiryConfig getBuildExpiryConfig() {
        return this.myBuildExpiryConfiguration;
    }

    @Nullable
    public ElasticConfiguration getElasticConfig() {
        return this.elasticConfig;
    }

    public void setElasticConfig(ElasticConfiguration elasticConfig) {
        this.elasticConfig = elasticConfig;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public void setSystemProperty(String key, String value) {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        this.systemProperties.put(key, value);
    }

    @Nullable
    public String getSystemProperty(String key) {
        if (this.systemProperties == null) {
            return null;
        }
        return this.systemProperties.get(key);
    }

    @Deprecated
    public void setGlobalVariable(String key, String value) {
        throw new UnsupportedOperationException("Global Variables are no longer stored in the Administration Configuration. Please use the com.atlassian.bamboo.variable.VariableDefinitionManager instead.");
    }

    @Deprecated
    @Nullable
    public String getGlobalVariable(String key) {
        throw new UnsupportedOperationException("Global Variables are no longer stored in the Administration Configuration. Please use the com.atlassian.bamboo.variable.VariableDefinitionManager instead.");
    }

    @Deprecated
    public void removeGlobalVariable(String key) {
        throw new UnsupportedOperationException("Global Variables are no longer stored in the Administration Configuration. Please use the com.atlassian.bamboo.variable.VariableDefinitionManager instead.");
    }

    @Deprecated
    @NotNull
    public Map<String, String> getGlobalVariables() {
        log.warn((Object)"Global Variables are no longer stored in the Administration Configuration. Please use the com.atlassian.bamboo.variable.VariableDefinitionManager instead.");
        if (this.globalVariables == null) {
            this.globalVariables = new HashMap<String, String>();
        }
        return this.globalVariables;
    }

    public ScheduleBackupConfiguration getScheduleBackupConfiguration() {
        return this.scheduleBackupConfiguration;
    }

    public void setScheduleBackupConfiguration(ScheduleBackupConfiguration scheduleBackupConfiguration) {
        this.scheduleBackupConfiguration = scheduleBackupConfiguration;
    }

    public String getInstanceName() {
        if (this.myInstanceName == null) {
            this.myInstanceName = "Atlassian Bamboo";
        }
        return this.myInstanceName;
    }

    public void setInstanceName(String instanceName) {
        this.myInstanceName = instanceName;
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.remoteAgentFunctionEnabled;
    }

    public void setRemoteAgentFunctionEnabled(boolean enabled) {
        this.remoteAgentFunctionEnabled = enabled;
    }

    public boolean isRemoteAgentAuthenticationEnabled() {
        return this.remoteAgentAuthenticationEnabled;
    }

    public void setRemoteAgentAuthenticationEnabled(boolean remoteAgentAuthenticationEnabled) {
        this.remoteAgentAuthenticationEnabled = remoteAgentAuthenticationEnabled;
    }

    public BuildHangingConfig getBuildHangingConfig() {
        return this.myBuildHangingConfig;
    }

    public void setBuildHangingConfig(BuildHangingConfig myBuildHangingConfig) {
        this.myBuildHangingConfig = myBuildHangingConfig;
    }

    public boolean isGravatarSupportEnabled() {
        return this.gravatarSupportEnabled;
    }

    public void setGravatarSupportEnabled(boolean gravatarSupportEnabled) {
        this.gravatarSupportEnabled = gravatarSupportEnabled;
    }

    public int getBuildHangedInQueueNotificationTimeout() {
        if (this.buildHangedInQueueNotificationTimeout <= 0) {
            return 120;
        }
        return this.buildHangedInQueueNotificationTimeout;
    }

    public void setBuildHangedInQueueNotificationTimeout(int buildHangedInQueueNotificationTimeout) {
        this.buildHangedInQueueNotificationTimeout = buildHangedInQueueNotificationTimeout;
    }

    public boolean isEnableRestrictedAdmin() {
        return this.enableRestrictedAdmin;
    }

    public void setEnableRestrictedAdmin(boolean enableRestrictedAdmin) {
        this.enableRestrictedAdmin = enableRestrictedAdmin;
    }

    public boolean isAuditLoggingEnabled() {
        return this.auditLoggingEnabled;
    }

    public void setAuditLoggingEnabled(boolean auditLoggingEnabled) {
        this.auditLoggingEnabled = auditLoggingEnabled;
    }

    @NotNull
    public RepositorySettings getRepositorySettings() {
        if (this.repositorySettings == null) {
            this.repositorySettings = new RepositorySettings();
        }
        return this.repositorySettings;
    }

    public void setRepositorySettings(RepositorySettings repositorySettings) {
        this.repositorySettings = repositorySettings;
    }

    @NotNull
    public Map<String, String> getArtifactHandlerConfiguration() {
        if (this.artifactHandlerConfiguration == null) {
            this.artifactHandlerConfiguration = Maps.newHashMap();
        }
        return this.artifactHandlerConfiguration;
    }
}

