/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperty {
    private static Logger log = Logger.getLogger(SystemProperty.class);
    private String myPropertyValue;
    private String myPropertyKey;
    public static final String BAMBOO_HOME_PROPERTY_NAME = "bamboo.home";
    public static final SystemProperty BAMBOO_HOME_FROM_ENV = new SystemProperty(false, "bamboo.home", "BAMBOO_HOME");
    public static final SystemProperty MAVEN_HOME = new SystemProperty(false, "MAVEN_HOME");
    public static final SystemProperty MAVEN2_HOME = new SystemProperty(false, "M2_HOME", "MAVEN2_HOME");
    public static final SystemProperty ANT_HOME = new SystemProperty(false, "ANT_HOME");
    public static final SystemProperty DEFAULT_CVS_ROOT = new SystemProperty(false, "CVSROOT");
    public static final SystemProperty DEFAULT_PERFORCE_PORT = new SystemProperty(false, "P4PORT");
    public static final SystemProperty DEFAULT_PERFORCE_CLIENT = new SystemProperty(false, "P4CLIENT");
    public static final SystemProperty DEFAULT_PERFORCE_USER = new SystemProperty(false, "P4USER");
    public static final SystemProperty DEFAULT_P4_EXE = new SystemProperty(false, "P4EXE");
    public static final SystemProperty FIND_SUCCESS_MESSAGE_IN_LAST = new SystemProperty(false, "SUCCESS_MESSAGE_LINES");
    public static final SystemProperty BUILD_SUCCESSFUL_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.successMarker");
    public static final SystemProperty BUILD_FAILED_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.failedMarker");
    public static final SystemProperty SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = new SystemProperty(false, "bamboo.build.searchSuccessFailMessageEverywhere");
    public static final SystemProperty DISABLE_AGENT_AUTO_CAPABILITY_DETECTION = new SystemProperty(false, "DISABLE_AGENT_AUTO_CAPABILITY_DETECTION");
    public static final SystemProperty SVN_SPOOL_TO_FILE = new SystemProperty(false, "SVN_SPOOL_TO_FILE");
    public static final SystemProperty BUILDING_DISABLED = new SystemProperty(false, "atlassian.bamboo.build.disable");
    public static final SystemProperty PATH = new SystemProperty(false, "PATH", "Path", "path");
    public static final SystemProperty CVS_TIME_DIFF = new SystemProperty(false, "atlassian.bamboo.cvsTimeDiff");
    public static final SystemProperty CVS_CHECKOUT_FORMAT = new SystemProperty(false, "CVS_CHECKOUT_FORMAT");
    public static final SystemProperty CVS_FORCE_CHECKOUT_TO_LATEST = new SystemProperty(false, "CVS_FORCE_CHECKOUT_TO_LATEST");
    public static final int CVS_SOCKET_TIMEOUT_MS = new SystemProperty(false, "CVS_SOCKET_TIMEOUT_MS").getValue(60000);
    public static final SystemProperty BUILD_RESULTS_CACHE_SIZE = new SystemProperty(false, "BUILD_RESULTS_CACHE_SIZE");
    public static final SystemProperty FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = new SystemProperty(false, "FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS");
    @Deprecated
    public static final SystemProperty SVN_14_COMPATIBLE = new SystemProperty(false, "bamboo.svn.compatibility.14");
    public static final SystemProperty SVN_WC_FORMAT = new SystemProperty(false, "bamboo.svn.wc.format");
    public static final SystemProperty SVN_CACHE_CREDENTIALS = new SystemProperty(false, "bamboo.svn.cache.credentials");
    public static final SystemProperty LOG_LINES_FOR_NOTIFICATIONS = new SystemProperty(false, "bamboo.notifications.logLinesToInclude");
    public static final SystemProperty ELASTIC_IMAGE_AMI_ID = new SystemProperty(false, "bamboo.aws.amiId");
    public static final SystemProperty EC2_TUNNEL_ENABLED = new SystemProperty(false, "bamboo.ec2.tunnel.enabled");
    public static final SystemProperty EC2_IGNORE_CERT_CHECK = new SystemProperty(false, "bamboo.ec2.ignoreCertCheck");
    public static final SystemProperty FIRE_INITAL_BUILD_FOR_MANUAL_STRATEGY = new SystemProperty(false, "fire.initial.build.for.manual.strategy");
    public static final SystemProperty ALLOW_UNSUPPORTED_DB = new SystemProperty(false, "bamboo.enable.unsupported.db");
    public static final boolean PATH_SET_ALLOWED = new SystemProperty(false, "bamboo.paths.set.allowed").getValue(false);
    public static final SystemProperty BUILD_PARENT_JAVA_IO_TMPDIR = new SystemProperty(false, "bamboo.build.parent.java.io.tmpdir", "java.io.tmpdir");
    public static final SystemProperty EVENT_MANAGER_CORE_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.corePoolSize");
    public static final SystemProperty EVENT_MANAGER_MAXIMUM_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.maximumPoolSize");
    public static final SystemProperty HG_COMMAND_FORCE_DEBUG = new SystemProperty(false, "bamboo.hg.debug");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_ID = new SystemProperty(false, "bamboo.ec2.agentLogAwsId");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_SECRET = new SystemProperty(false, "bamboo.ec2.agentLogSecret");
    public static final SystemProperty BAMBOO_DELETION_ENABLED = new SystemProperty(false, "bamboo.deletion.enabled");
    public static final SystemProperty BAMBOO_RELOAD_AGENT_CLASSPATH = new SystemProperty(false, "bamboo.agent.reloadclasspath");
    public static final SystemProperty BAMBOO_MAX_AGENTS_LOADING = new SystemProperty(false, "bamboo.agent.max_loading");
    public static final SystemProperty BAMBOO_FREEMARKER_DEBUG = new SystemProperty(false, "bamboo.freemarker.debug");
    public static final SystemProperty MAX_VCS_OPERATION_RETRIES = new SystemProperty(false, "bamboo.vcs.retries");
    public static final SystemProperty PLAN_EXECUTION_DETECTION_THREADS = new SystemProperty(false, "bamboo.plan.exe.threads");

    public SystemProperty(boolean mandatory, String ... properties) {
        for (String property : properties) {
            this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
            if (this.myPropertyValue == null) continue;
            this.myPropertyKey = property;
            break;
        }
    }

    protected SystemProperty(String property, boolean mandatory, Logger log) {
        SystemProperty.log = log;
        this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
    }

    @Nullable
    public String getValue() {
        return this.myPropertyValue;
    }

    public String getKey() {
        return this.myPropertyKey;
    }

    @NotNull
    public String getValue(@NotNull String defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue;
    }

    public boolean getValue(boolean defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue.equals("true");
    }

    @Nullable
    protected static String getEnvironmentVariable(@NotNull String variable, boolean mandatory) {
        String value = System.getProperty(variable);
        if (value == null) {
            try {
                value = SystemProperty.obtainVariableFromSystemEnvironment(variable);
            }
            catch (Throwable throwable) {
                log.error((Object)("Could not access the system environment variable:\"" + variable + "\""), throwable);
                return null;
            }
        }
        if (value == null && mandatory) {
            log.error((Object)("Cannot find the " + variable + " environment variable"));
        }
        return value;
    }

    @Nullable
    private static String obtainVariableFromSystemEnvironment(@NotNull String variable) {
        try {
            String envVar = SystemProperty.getEnvVariableCaseSensitive(variable);
            if (envVar != null) {
                return envVar;
            }
        }
        catch (NoSuchMethodError e) {
            log.warn((Object)("Cannot access system environment variable " + variable + " using JRE1.4. Truying an alternative method"));
        }
        return SystemProperty.getPropertyFromAntEnv(variable);
    }

    private static String getEnvVariableCaseSensitive(String variable) {
        return System.getenv().get(variable);
    }

    @Nullable
    static String getPropertyFromAntEnv(@NotNull String variable) {
        Collection env = (Collection)Execute.getProcEnvironment().clone();
        for (Object anEnv : env) {
            String var = (String)anEnv;
            String key = StringUtils.substringBefore((String)var, (String)"=");
            if (!variable.equals(key)) continue;
            return StringUtils.substringAfter((String)var, (String)"=");
        }
        return null;
    }

    public void setValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public boolean exists() {
        return StringUtils.isNotEmpty((String)this.getValue());
    }

    public int getValue(int defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getValue(long defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

