/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;

public class BuildExpiryConfig
implements Serializable {
    public static final String DAYS = "days";
    public static final String WEEKS = "weeks";
    public static final String MONTHS = "months";
    public static final String BUILD_LOG_EXPIRY = "buildlog";
    public static final String ARTIFACT_EXPIRY = "artifact";
    public static final String RESULTS_EXPIRY = "result";
    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 ? * *";
    private String myPeriod;
    private int myDuration;
    private int buildsToKeep;
    private boolean expiryTypeResult;
    private boolean expiryTypeArtifact;
    private boolean expiryTypeBuildLog;
    private String excludeLabels;
    private String labelsToKeep;
    private String cronExpression;
    private boolean disabled = false;

    public BuildExpiryConfig() {
    }

    public BuildExpiryConfig(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(int duration, String period) {
        this.myPeriod = period;
        this.myDuration = duration;
    }

    public BuildExpiryConfig(int duration, String period, int buildsToKeep) {
        this(duration, period);
        this.buildsToKeep = buildsToKeep;
    }

    public BuildExpiryConfig(Collection<BuildExpiryType> expiryType, int duration, String period, int buildsToKeep) {
        this(duration, period, buildsToKeep);
        this.setBuildExpiryTypes(expiryType);
    }

    public BuildExpiryConfig(Collection<BuildExpiryType> expiryType, int duration, String period, int buildsToKeep, String excludeLabels, String labelsToKeep) {
        this(expiryType, duration, period, buildsToKeep);
        this.labelsToKeep = labelsToKeep;
        this.excludeLabels = excludeLabels;
    }

    public boolean getExpiryTypeResult() {
        return this.expiryTypeResult;
    }

    public void setExpiryTypeResult(boolean expiryTypeResult) {
        this.expiryTypeResult = expiryTypeResult;
        if (expiryTypeResult) {
            this.expiryTypeArtifact = true;
            this.expiryTypeBuildLog = true;
        }
    }

    public boolean getExpiryTypeArtifact() {
        return this.expiryTypeArtifact;
    }

    public void setExpiryTypeArtifact(boolean expiryTypeArtifact) {
        this.expiryTypeArtifact = expiryTypeArtifact;
    }

    public boolean getExpiryTypeBuildLog() {
        return this.expiryTypeBuildLog;
    }

    public void setExpiryTypeBuildLog(boolean expiryTypeBuildLog) {
        this.expiryTypeBuildLog = expiryTypeBuildLog;
    }

    public Collection<BuildExpiryType> getBuildExpiryTypes() {
        ArrayList expiryTypes = Lists.newArrayList();
        if (this.expiryTypeResult) {
            expiryTypes.add(BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE);
        }
        if (this.expiryTypeArtifact) {
            expiryTypes.add(BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE);
        }
        if (this.expiryTypeBuildLog) {
            expiryTypes.add(BuildExpiryType.BUILD_LOG_EXPIRY_TYPE);
        }
        return expiryTypes;
    }

    public String getBuildExpiryTypesLabel() {
        return StringUtils.join(this.getBuildExpiryTypes(), (String)", ");
    }

    public void setBuildExpiryTypes(Collection<BuildExpiryType> expiryTypes) {
        for (BuildExpiryType expiryType : expiryTypes) {
            if (BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE.equals(expiryType)) {
                this.setExpiryTypeArtifact(true);
            }
            if (BuildExpiryType.BUILD_LOG_EXPIRY_TYPE.equals(expiryType)) {
                this.setExpiryTypeBuildLog(true);
            }
            if (!BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE.equals(expiryType)) continue;
            this.setExpiryTypeResult(true);
        }
    }

    public String getPeriod() {
        return this.myPeriod;
    }

    public int getDuration() {
        return this.myDuration;
    }

    public int getBuildsToKeep() {
        return this.buildsToKeep;
    }

    public void setBuildsToKeep(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public void setPeriod(String myPeriod) {
        this.myPeriod = myPeriod;
    }

    public void setDuration(int myDuration) {
        this.myDuration = myDuration;
    }

    public boolean isExpireByDate() {
        return this.getDuration() > 0;
    }

    public boolean isExpireByBuild() {
        return this.getBuildsToKeep() > 0;
    }

    public String getLabelsToKeep() {
        return this.labelsToKeep;
    }

    public void setLabelsToKeep(String labelsToKeep) {
        this.labelsToKeep = labelsToKeep;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public void setExcludeLabels(String excludeLabels) {
        this.excludeLabels = excludeLabels;
    }

    @NotNull
    public String getCronExpression() {
        if (this.cronExpression != null) {
            return this.cronExpression;
        }
        return DEFAULT_CRON_EXPRESSION;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public List<String> getLabelsList() {
        if (this.labelsToKeep == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)this.getLabelsToKeep(), (String)" ,"));
    }

    public Period getExpiryPeriod() {
        if (DAYS.equals(this.myPeriod)) {
            return Period.days((int)this.myDuration);
        }
        if (WEEKS.equals(this.myPeriod)) {
            return Period.weeks((int)this.myDuration);
        }
        if (MONTHS.equals(this.myPeriod)) {
            return Period.months((int)this.myDuration);
        }
        throw new IllegalStateException("\"" + this.myPeriod + "\" is an unknown period");
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean enabled) {
        this.disabled = enabled;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this).append("Builds to Keep", this.getBuildsToKeep()).append("Period", (Object)(this.getDuration() + " " + this.getPeriod()));
        if (Boolean.parseBoolean(this.getExcludeLabels())) {
            toStringBuilder.append("Labels to Keep", (Object)this.getLabelsToKeep());
        }
        return toStringBuilder.toString();
    }
}

