/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;

public class BuildAgentTypeAccessor {
    private BuildAgentTypeAccessor() {
    }

    public static boolean isElastic(BuildAgent agent) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(agent);
        return type.equals((Object)PipelineDefinition.TYPE.ELASTIC);
    }

    public static boolean isElastic(PipelineDefinition definition) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(definition);
        return type.equals((Object)PipelineDefinition.TYPE.ELASTIC);
    }

    public static boolean isLocal(BuildAgent agent) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(agent);
        return type.equals((Object)PipelineDefinition.TYPE.LOCAL);
    }

    public static boolean isLocal(PipelineDefinition definition) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(definition);
        return type.equals((Object)PipelineDefinition.TYPE.LOCAL);
    }

    public static boolean isRemote(BuildAgent agent) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(agent);
        return type.equals((Object)PipelineDefinition.TYPE.REMOTE);
    }

    public static boolean isRemote(PipelineDefinition definition) {
        PipelineDefinition.TYPE type = BuildAgentTypeAccessor.getAgentType(definition);
        return type.equals((Object)PipelineDefinition.TYPE.REMOTE);
    }

    public static PipelineDefinition.TYPE getAgentType(BuildAgent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Illegal agent has been provided.");
        }
        return BuildAgentTypeAccessor.getAgentType(agent.getDefinition());
    }

    public static PipelineDefinition.TYPE getAgentType(PipelineDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("Illegal agent definition has been provided.");
        }
        MyPipelineDefinitionVisitor definitionVisitor = new MyPipelineDefinitionVisitor();
        definition.accept(definitionVisitor);
        PipelineDefinition.TYPE type = definitionVisitor.getAgentType();
        return type;
    }

    private static class MyPipelineDefinitionVisitor
    implements PipelineDefinitionVisitor {
        private PipelineDefinition.TYPE agentType;

        private MyPipelineDefinitionVisitor() {
        }

        @Override
        public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
            this.agentType = PipelineDefinition.TYPE.ELASTIC;
        }

        @Override
        public void visitLocal(LocalAgentDefinition pipelineDefinition) {
            this.agentType = PipelineDefinition.TYPE.LOCAL;
        }

        @Override
        public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
            this.agentType = PipelineDefinition.TYPE.REMOTE;
        }

        public PipelineDefinition.TYPE getAgentType() {
            return this.agentType;
        }
    }
}

