/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public abstract class RecentLazyReference<T>
extends ResettableLazyReference<T> {
    private final IsTooOldPredicate isTooOldPredicate;

    public RecentLazyReference(long amount, TimeUnit unit) {
        this.isTooOldPredicate = new IsTooOldPredicate(amount, unit);
    }

    public synchronized T get() {
        boolean shouldRefresh = this.isTooOldPredicate.evaluate(new Date());
        if (shouldRefresh) {
            this.reset();
        }
        Object ref = super.get();
        if (shouldRefresh) {
            this.isTooOldPredicate.reset();
        }
        return (T)ref;
    }

    public static class IsTooOldPredicate
    implements Predicate {
        private final long amount;
        private final TimeUnit unit;
        private Date nextRefreshTime;

        public IsTooOldPredicate(long amount, @NotNull TimeUnit unit) {
            this.amount = amount;
            this.unit = unit;
        }

        public boolean evaluate(Object object) {
            return this.nextRefreshTime == null || ((Date)object).after(this.nextRefreshTime);
        }

        public void reset() {
            this.nextRefreshTime = DateUtils.addMilliseconds((Date)new Date(), (int)((int)this.unit.toMillis(this.amount)));
        }
    }
}

