/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.DoubleThrowingPredicate;
import com.atlassian.bamboo.util.ThrowingPredicate;
import org.jetbrains.annotations.Nullable;

public final class BambooIterables {
    private BambooIterables() {
    }

    @Nullable
    public static <T, E extends Throwable> T find(Iterable<T> iterable, ThrowingPredicate<? super T, E> predicate, @Nullable T defaultValue) throws E {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    @Nullable
    public static <T, E extends Throwable, F extends Throwable> T find(Iterable<T> iterable, DoubleThrowingPredicate<? super T, E, F> predicate, @Nullable T defaultValue) throws E, F {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }
}

