/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.persistence3.BambooObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface BuildResultsSummaryDao
extends BambooObjectDao<ResultsSummary> {
    public static final int NUMBER_OF_DAYS_TO_FILTER = 7;

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInUnknownState(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllPendingResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllQueuedResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllInProgressResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllActiveResultSummariesForPlan(PlanKey var1, Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getFinalizedResultSummariesForPlan(PlanKey var1, Class<T> var2, int var3, int var4);

    public int getNumberOfConcurrentlyRunningBuilds(PlanKey var1);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2, ResultDataRead var3);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInBuildState(@NotNull BuildState var1, Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInLifeCycleState(@NotNull LifeCycleState var1, Class<T> var2);

    @NotNull
    public Collection<BuildResultsSummary> getAllInProgressBuildResultSummaries();

    @Deprecated
    @Nullable
    public BuildResultsSummary getBuildResultsSummaryByBuildKeyAndBuildNumber(String var1, int var2);

    @Nullable
    public BuildResultsSummary getFirstBuildSummary(Plan var1);

    public <T extends ResultsSummary> T getLastResultSummary(String var1, Class<T> var2);

    public long getNumberOfFinishedResults(Plan var1);

    public long getNumberOfFinalizedResults(@NotNull Plan var1);

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(Plan var1, int var2);

    @Nullable
    public ResultsSummary getBreakingBuild(ResultsSummary var1);

    @Nullable
    public ResultsSummary getFixingBuild(ResultsSummary var1);

    @Deprecated
    @NotNull
    public <T extends BuildResultsSummary> List<T> findBuildResultsSummaries(@NotNull BuildResultsSummaryCriteria var1);

    @NotNull
    public <T extends ResultsSummary> List<T> findResultsSummaries(@NotNull ResultsSummaryCriteria var1);

    public int removeResultsSummariesForPlan(@NotNull PlanKey var1);

    public int removeAllOrphanedResultSummaries();

    public int countBuildResultsSummaries(long var1, @Nullable BuildState var3);

    public int countBuildResultsSummaries(@Nullable String var1);

    @Deprecated
    public void removeBuildResultsSummary(BuildResultsSummary var1);

    public void removeResultsSummary(@NotNull ResultsSummary var1);

    @NotNull
    public List<ResultsSummary> findBuildResultsSummariesByJiraIssues(@Nullable List<String> var1);

    @NotNull
    public List<ResultsSummary> findBuildResultsSummariesByProjectKey(@Nullable String var1);

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForBuildResults(@NotNull List<ResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForBuild(@NotNull Plan var1);

    @NotNull
    public List<BuildResultsSummary> findBuildsForImageConfiguration(String var1, ElasticImageConfiguration var2, @Nullable BuildState var3, int var4);

    @Nullable
    public <T extends ResultsSummary> T findLastBuildResultBeforeWithTests(@NotNull PlanResultKey var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull String var1, int var2, Class<T> var3);

    @Nullable
    public <T extends ResultsSummary> T findFirstResultAfter(@NotNull String var1, int var2, Class<T> var3);

    @Nullable
    public ResultsSummary findFirstBuildResultWithBuildStateAfter(@NotNull String var1, int var2, @NotNull BuildState var3);

    public ResultsSummary findLastBuildResultWithBuildStateBefore(@NotNull String var1, int var2, @NotNull BuildState var3);

    @Nullable
    public ResultsSummary findFirstBuildResultWithBuildStateBetween(@NotNull String var1, int var2, int var3, @NotNull BuildState var4);

    @Nullable
    public Integer findFirstBuildNumberAfter(@NotNull String var1, int var2);

    @Nullable
    public Integer findLastBuildNumberBefore(@NotNull String var1, int var2);

    public List<Pair<ArtifactLink, BuildResultsSummary>> findBuildResultsWithArtifacts(String var1);

    public long scrollResultSummaries(@NotNull String var1, @NotNull ResultDataRead var2, @NotNull Function<ResultsSummary, Void> var3);

    public long scrollJiraIssuesForExport(@NotNull Function<LinkedJiraIssue, Void> var1);

    @Nullable
    public ChainStageResult getChainStageResultById(long var1);

    public <T extends ResultsSummary> List<T> getAllResultSummariesForPlan(@NotNull Plan var1);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlan(@NotNull Plan var1, int var2, int var3);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlanByLifeCycleState(@NotNull Plan var1, @NotNull LifeCycleState var2, int var3, int var4);

    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetId(@NotNull String var1, Class<T> var2);

    @Nullable
    public ChainResultsSummary getParentResultSummary(ResultsSummary var1);

    @Nullable
    public ChainStageResult getStageForResult(ResultsSummary var1);

    public List<ResultsSummary> findLatestResultsSummaries();

    public List<ResultsSummary> findLatestFailedResultSummaries();

    public List<ChainResultsSummary> findChainResultsWithJobLabelled(ResultsSummaryCriteria var1, List<Label> var2);

    @Nullable
    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey var1, @NotNull BuildState var2, @NotNull Class<T> var3);

    public int countResultsWithState(@NotNull PlanKey var1, int var2, int var3, @NotNull BuildState var4);

    public long scrollVariableSubstitutionForExport(@NotNull Function<VariableSubstitution, Void> var1);
}

