/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.process;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@PublicApi
public final class ExternalProcessBuilder {
    private static final Logger log = Logger.getLogger(ExternalProcessBuilder.class);
    private final LinkedList<String> paths = new LinkedList();
    private final List<String> command = new LinkedList<String>();
    private File workingDirectory;
    private final Map<String, String> env = new HashMap<String, String>();

    public ExternalProcessBuilder path(@NotNull String path) {
        this.paths.add(path);
        return this;
    }

    public ExternalProcessBuilder path(@NotNull List<String> path) {
        this.paths.addAll(path);
        return this;
    }

    public ExternalProcessBuilder command(@NotNull List<String> command) {
        this.command.addAll(command);
        return this;
    }

    public ExternalProcessBuilder commandFromString(@NotNull String commandString) {
        return this.command(CommandlineStringUtils.tokeniseCommandline(commandString));
    }

    public ExternalProcessBuilder env(@NotNull Map<String, String> env) {
        String pathValue = env.get(SystemProperty.PATH.getKey());
        if (pathValue != null) {
            this.pathAppendFront(pathValue);
        }
        this.env.putAll(Maps.filterEntries(env, (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                return !input.getKey().equals(SystemProperty.PATH.getKey());
            }
        }));
        return this;
    }

    public ExternalProcessBuilder env(@NotNull String key, @NotNull String value) {
        if (key.equals(SystemProperty.PATH.getKey())) {
            this.pathAppendFront(value);
        } else {
            this.env.put(key, value);
        }
        return this;
    }

    public ExternalProcessBuilder workingDirectory(@NotNull File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public List<String> getPaths() {
        return Lists.newArrayList(this.paths);
    }

    public List<String> getCommand() {
        return Lists.newArrayList(this.command);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Map<String, String> getEnv() {
        return Maps.newHashMap(this.env);
    }

    private void pathAppendFront(String value) {
        this.paths.push(value);
    }
}

