/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

@Internal
public enum PlanType {
    CHAIN(Chain.class),
    BUILD(Build.class),
    JOB(Job.class);

    private final Class<? extends Plan> aClass;
    private static final Collection<PlanType> topLevelPlans;
    private final boolean isTopLevelPlan;
    private final boolean isBuildable;

    private PlanType(Class<? extends Plan> aClass) {
        this.aClass = aClass;
        this.isTopLevelPlan = TopLevelPlan.class.isAssignableFrom(aClass);
        this.isBuildable = Buildable.class.isAssignableFrom(aClass);
    }

    public Class<? extends Plan> getClassType() {
        return this.aClass;
    }

    public boolean isTopLevelPlan() {
        return this.isTopLevelPlan;
    }

    public boolean isBuildable() {
        return this.isBuildable;
    }

    @NotNull
    public static Collection<PlanType> getTopLevelPlans() {
        return topLevelPlans;
    }

    static {
        topLevelPlans = Collections2.filter((Collection)Lists.newArrayList((Object[])PlanType.values()), (Predicate)new Predicate<PlanType>(){

            public boolean apply(@NotNull PlanType input) {
                return input.isTopLevelPlan();
            }
        });
    }
}

