/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface PlanManager {
    @Nullable
    public Plan getPlanById(long var1) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanById(long var1, Class<T> var3) throws IncorrectPlanTypeException;

    @Nullable
    public Plan getPlanByKey(@NotNull String var1) throws IncorrectPlanTypeException;

    @Nullable
    public Plan getPlanSkeletonForPermissionCheckingByKey(@NotNull String var1);

    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull String var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByKeyIfOfType(@NotNull String var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends Plan> T getPlanByKeyIfOfType(@NotNull PlanKey var1, @NotNull Class<T> var2);

    @Nullable
    public Plan getPlanByKey(@NotNull PlanKey var1) throws IncorrectPlanTypeException;

    public boolean assertPlanPermission(@NotNull Plan var1);

    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull PlanKey var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public Plan getPlanByResultKey(@NotNull PlanResultKey var1) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByResultKey(@NotNull PlanResultKey var1, Class<T> var2) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByName(@NotNull String var1, @NotNull String var2, Class<T> var3) throws IncorrectPlanTypeException;

    @Nullable
    public <T extends Plan> T getPlanByPartialKeyAndName(@NotNull PlanKey var1, @NotNull String var2, Class<T> var3) throws IncorrectPlanTypeException;

    @NotNull
    public List<TopLevelPlan> getAllPlans();

    public List<TopLevelPlan> getAllPlansUnrestricted();

    @NotNull
    public <T extends Plan> List<T> getAllPlans(Class<T> var1);

    @NotNull
    public List<TopLevelPlan> getPlansByProject(Project var1);

    @NotNull
    public <T extends Plan> List<T> getPlansByProject(Project var1, Class<T> var2);

    @NotNull
    public <T extends Plan> List<T> getAllPlansByProject(Project var1, Class<T> var2);

    @NotNull
    public <T extends Plan> Map<Project, Collection<T>> getProjectPlanMap(Class<T> var1, boolean var2);

    public int getPlanCount();

    public <T extends Plan> int getPlanCount(Class<T> var1);

    public void savePlan(@NotNull Plan var1);

    public void setPlanSuspendedState(Plan var1, boolean var2);

    public boolean isPlanCreationAllowed();

    public void updateNamesAndDescription(@NotNull String var1, @NotNull String var2, @Nullable String var3, @NotNull Plan var4);

    public void createPlan(Plan var1);

    public void deletePlan(Plan var1);

    public Map<PlanKey, PlanKey> movePlanToProject(Plan var1, Project var2, String var3, String var4);

    public Set<TopLevelPlan> getFavouritePlans(@NotNull User var1);

    @NotNull
    public Set<TopLevelPlan> filterFavouritedPlans(@NotNull Collection<TopLevelPlan> var1, @NotNull User var2);

    @NotNull
    public <T extends Plan> Collection<T> getAllPlansMarkedForDeletion(Class<T> var1);
}

