/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import java.io.Serializable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public class ThrowableDetails
implements Serializable {
    private final String name;
    private final String message;
    private final String stackTrace;

    @Nullable
    public static ThrowableDetails fromThrowable(@Nullable Throwable throwable) {
        return throwable == null ? null : new ThrowableDetails(throwable);
    }

    private ThrowableDetails(Throwable throwable) {
        this.name = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTrace = ExceptionUtils.getFullStackTrace((Throwable)throwable);
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }
}

