/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.set.ListOrderedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorDetails {
    private final int errorNumber;
    private final String buildKey;
    private final String context;
    private final ThrowableDetails throwableDetails;
    private final Date firstOccurred;
    @GuardedBy(value="this")
    private final Set<Long> agentIds = new ListOrderedSet();
    private volatile Date lastOccurred;
    private volatile Integer buildNumber;
    private volatile int numberOfOccurrences = 1;
    private final PlanManager planManager;
    private final AgentManager agentManager;
    private final BuildResultsSummaryManager buildResultsSummaryManager;
    public static final String ALL_BUILDS = "All Builds";
    public static final String ELASTIC_BAMBOO = "Elastic Bamboo";

    public ErrorDetails(int errorNumber, String planKey, Integer buildNumber, @Nullable Long agentId, String context, @Nullable Date timeStamp, @Nullable ThrowableDetails throwableDetails, PlanManager planManager, AgentManager agentManager, BuildResultsSummaryManager buildResultsSummaryManager) {
        this.errorNumber = errorNumber;
        this.buildKey = planKey;
        this.context = context;
        this.throwableDetails = throwableDetails;
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        this.firstOccurred = timeStamp;
        this.lastOccurred = timeStamp;
        this.buildNumber = buildNumber;
        this.planManager = planManager;
        this.agentManager = agentManager;
        this.buildResultsSummaryManager = buildResultsSummaryManager;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
    }

    public int getErrorNumber() {
        return this.errorNumber;
    }

    public String getBuildName() {
        Plan plan = this.planManager.getPlanByKey(this.buildKey);
        if (plan != null) {
            return plan.getName();
        }
        return this.buildKey;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public String getBuildResultKey() {
        return this.buildKey + "-" + this.buildNumber;
    }

    public synchronized Set<Long> getAgentIds() {
        return this.agentIds;
    }

    public synchronized Collection<BuildAgent> getAgents() {
        return CollectionUtils.collect(this.getAgentIds(), (Transformer)new Transformer(){

            @Nullable
            public Object transform(Object input) {
                return ErrorDetails.this.agentManager.getAgent((Long)input);
            }
        });
    }

    public synchronized Collection<AgentIdentifier> getAgentIdentifiers() {
        return CollectionUtils.collect(this.getAgentIds(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                BuildAgent agent = ErrorDetails.this.agentManager.getAgent((Long)input);
                if (agent != null) {
                    return new AgentIdentifier(agent);
                }
                return new AgentIdentifier((Long)input);
            }
        });
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public String getContext() {
        return this.context;
    }

    @NotNull
    public Date getLastOccurred() {
        return this.lastOccurred;
    }

    @NotNull
    public Date getFirstOccurred() {
        return this.firstOccurred;
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Nullable
    public ThrowableDetails getThrowableDetails() {
        return this.throwableDetails;
    }

    synchronized void recordOccurrence(Date timeStamp, Integer buildNumber, Long agentId) {
        ++this.numberOfOccurrences;
        if (agentId != null) {
            this.agentIds.add(agentId);
        }
        if (timeStamp != null && (this.lastOccurred == null || timeStamp.after(this.lastOccurred))) {
            this.lastOccurred = timeStamp;
        }
        if (buildNumber != null && (this.buildNumber == null || buildNumber > this.buildNumber)) {
            this.buildNumber = buildNumber;
        }
    }

    public boolean isBuildExists() {
        if (this.buildNumber == null) {
            return false;
        }
        BuildResultsSummary buildResultsSummary = this.buildResultsSummaryManager.getBuildResultsSummary(this.buildKey, this.buildNumber);
        return buildResultsSummary != null;
    }

    public boolean isForAllBuilds() {
        return ALL_BUILDS.equals(this.buildKey);
    }

    public boolean isBuildSpecific() {
        return !ALL_BUILDS.equals(this.buildKey) && this.buildKey != null;
    }

    public boolean isElastic() {
        return false;
    }

    public static class AgentIdentifier {
        private String name;
        private final long id;

        private AgentIdentifier(long id) {
            this.id = id;
        }

        private AgentIdentifier(BuildAgent agent) {
            this.id = agent.getId();
            this.name = agent.getName();
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }
}

