/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMap<V>
implements Map<String, V> {
    private final String prefix;
    private final Map<String, V> decoratedMap;

    public FilteredMap(String prefix) {
        this.prefix = prefix;
        this.decoratedMap = new HashMap<String, V>();
    }

    public FilteredMap(String prefix, Map decoratedMap) {
        this.prefix = prefix + ".";
        this.decoratedMap = decoratedMap;
    }

    public FilteredMap<V> subset(String prefix) {
        return new FilteredMap<V>(prefix, this.decoratedMap);
    }

    @Override
    public int size() {
        return this.decoratedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.decoratedMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.decoratedMap.containsKey(this.prefix + key);
    }

    @Override
    public V get(Object key) {
        return this.decoratedMap.get(this.prefix + key);
    }

    @Override
    public V put(String key, V value) {
        return this.decoratedMap.put(this.prefix + key, value);
    }

    @Override
    public V remove(Object key) {
        return this.decoratedMap.remove(this.prefix + key);
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        return this.decoratedMap.values();
    }

    @Override
    public Set entrySet() {
        return this.decoratedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.decoratedMap).equals(o);
    }

    public Map getDecoratedMap() {
        return this.decoratedMap;
    }

    public static FilteredMap decorate(String prefix, Map params) {
        return new FilteredMap(prefix, params);
    }
}

