/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.File;
import org.apache.log4j.Logger;

public class JavaVirtualMachineDetector {
    private static final Logger log = Logger.getLogger(JavaVirtualMachineDetector.class);
    private boolean myIsRunningOnOsx;

    public JavaVirtualMachineDetector(boolean isRunningOnOsx) {
        this.myIsRunningOnOsx = isRunningOnOsx;
    }

    public String detectJavaHome(String systemJavaHome) {
        if (!this.myIsRunningOnOsx && systemJavaHome != null) {
            File systemJavaHomeDirectory = new File(systemJavaHome);
            if (this.containsToolsJar(systemJavaHomeDirectory) && this.containsJavac(systemJavaHomeDirectory)) {
                return systemJavaHome;
            }
            File parentDirectory = systemJavaHomeDirectory.getParentFile();
            if (this.containsToolsJar(parentDirectory) && this.containsJavac(parentDirectory)) {
                return systemJavaHomeDirectory.getParent();
            }
        }
        return systemJavaHome;
    }

    public boolean containsJavac(File givenDirectory) {
        if (this.myIsRunningOnOsx) {
            return true;
        }
        File javac = new File(givenDirectory, "bin" + File.separator + "javac");
        File javacWindows = new File(givenDirectory, "bin" + File.separator + "javac.exe");
        return javac.exists() || javacWindows.exists();
    }

    public boolean containsToolsJar(File givenDirectory) {
        if (this.myIsRunningOnOsx) {
            return true;
        }
        File toolsJar = new File(givenDirectory, "lib" + File.separator + "tools.jar");
        try {
            return toolsJar.exists();
        }
        catch (Exception e) {
            log.info((Object)"Failed", (Throwable)e);
            return false;
        }
    }
}

