/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.exception.DataAccessException;
import com.atlassian.bamboo.ww2.actions.build.admin.create.CustomizedXMLConfiguration;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    private static final Logger log = Logger.getLogger(ConfigUtils.class);

    public static void copyMapToConfig(Map map, Configuration config) {
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            config.setProperty(key, (Object)value);
        }
    }

    public static Map asMap(Configuration config, String filter) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(filter)) continue;
            m.put(key, config.getProperty(key));
        }
        return m;
    }

    public static void debugXmlConfig(XMLConfiguration configuration) {
        try {
            StringWriter buildXml2 = new StringWriter();
            configuration.save((Writer)buildXml2);
            System.out.println(buildXml2);
        }
        catch (ConfigurationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static void addNodesAt(HierarchicalConfiguration config, String rootPath, HierarchicalConfiguration configToAdd) {
        config.addNodes(rootPath, (Collection)configToAdd.getRoot().getChildren());
    }

    public static void addNodeAt(HierarchicalConfiguration buildConfiguration, String rootPath, HierarchicalConfiguration configToAdd) {
        buildConfiguration.addNodes(rootPath + "(-1)", (Collection)configToAdd.getRoot().getChildren());
    }

    public static void addMapToBuilConfiguration(@NotNull String keyForMap, @NotNull Map<String, String> map, @NotNull HierarchicalConfiguration buildConfiguration) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            HierarchicalConfiguration config = new HierarchicalConfiguration();
            config.setProperty("key", (Object)entry.getKey());
            config.setProperty("value", (Object)entry.getValue());
            ConfigUtils.addNodeAt(buildConfiguration, keyForMap + "." + "entry", config);
        }
    }

    @NotNull
    public static Map<String, String> getMapFromConfiguration(@NotNull String keyForMap, @NotNull HierarchicalConfiguration config) {
        HashMap<String, String> returnedMap = new HashMap<String, String>();
        List entries = config.configurationsAt(keyForMap + "." + "entry");
        if (entries != null) {
            for (SubnodeConfiguration entry : entries) {
                returnedMap.put(entry.getString("key"), entry.getString("value"));
            }
        }
        return returnedMap;
    }

    @NotNull
    public static Map<String, String> toStringMap(@NotNull Map<String, ?> objectsMap) {
        HashMap<String, String> returnMap = new HashMap<String, String>(objectsMap.size());
        for (Map.Entry<String, ?> entry : objectsMap.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            if (o != null) {
                returnMap.put(key, o.toString());
                continue;
            }
            returnMap.put(key, null);
        }
        return returnMap;
    }

    @NotNull
    public static Map<String, Long> toLongMap(@NotNull Map<String, String> stringMap) throws NumberFormatException {
        HashMap<String, Long> returnMap = new HashMap<String, Long>(stringMap.size());
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                returnMap.put(key, Long.parseLong(value));
                continue;
            }
            returnMap.put(key, null);
        }
        return returnMap;
    }

    @NotNull
    public static String asXmlString(@NotNull XMLConfiguration configuration) {
        StringWriter buildXml = new StringWriter();
        try {
            configuration.save((Writer)buildXml);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Failed to write configuration as XML", (Throwable)e);
            throw new DataAccessException(e);
        }
        return buildXml.toString();
    }

    @NotNull
    public static XMLConfiguration getXmlConfigFromXmlString(@NotNull String xmlData) {
        CustomizedXMLConfiguration xmlConfiguration;
        try {
            xmlConfiguration = new CustomizedXMLConfiguration();
            xmlConfiguration.load(new StringReader(xmlData));
        }
        catch (ConfigurationException e) {
            log.error((Object)("Error getting Build Configuration from '" + xmlData + "'."), (Throwable)e);
            throw new DataAccessException(e);
        }
        return xmlConfiguration;
    }

    public static void copyNodes(@NotNull HierarchicalConfiguration sourceConfig, @NotNull XMLConfiguration targetConfig) {
        targetConfig.addNodes(null, (Collection)((HierarchicalConfiguration)sourceConfig.clone()).getRootNode().getChildren());
    }
}

