/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlUtils {
    private static final Logger log = Logger.getLogger(UrlUtils.class);

    public static String replaceOrInsertParamValue(String queryString, String paramField, String newParamValue) {
        if (queryString == null) {
            return null;
        }
        if (queryString.indexOf("buildNumber=") == -1) {
            queryString = queryString.indexOf("?") != -1 ? (queryString.endsWith("&") ? queryString + "buildNUmber=" + newParamValue : queryString + "&buildNumber=" + newParamValue) : queryString + "?buildNumber=" + newParamValue;
            return queryString;
        }
        return queryString.replaceAll("buildNumber=[0-9]*", "buildNumber=" + newParamValue);
    }

    public static String correctlyFormatUrl(String host) {
        if (host == null) {
            return null;
        }
        if (StringUtils.isBlank((String)host)) {
            return host;
        }
        StringBuffer urlToReturn = new StringBuffer(host);
        if (!host.startsWith("http://") && !host.startsWith("https://")) {
            urlToReturn.insert(0, "http://");
        }
        while (urlToReturn.charAt(urlToReturn.length() - 1) == '/') {
            urlToReturn.deleteCharAt(urlToReturn.length() - 1);
        }
        return urlToReturn.toString();
    }

    @NotNull
    public static String stripLeadingSlashes(@Nullable String toStrip) {
        int i;
        if (toStrip == null) {
            return "";
        }
        for (i = 0; toStrip.length() > i && '/' == toStrip.charAt(i); ++i) {
        }
        return toStrip.substring(i);
    }

    @NotNull
    public static String appendSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.endsWith("/")) {
            return theString + "/";
        }
        return theString;
    }
}

