/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;

public class UrlBuilder {
    private String urlWithNoParams;
    private MultiMap params = new MultiHashMap();

    public UrlBuilder setUrl(String url) {
        String strQueryString;
        if (StringUtils.isEmpty((String)url)) {
            this.urlWithNoParams = "";
            return this;
        }
        StringTokenizer tokenizerQueryString = new StringTokenizer(url, "?");
        this.urlWithNoParams = tokenizerQueryString.nextToken();
        this.params.clear();
        if (tokenizerQueryString.hasMoreTokens() && (strQueryString = tokenizerQueryString.nextToken()) != null) {
            StringTokenizer tokenizerNameValuePair = new StringTokenizer(strQueryString, "&");
            while (tokenizerNameValuePair.hasMoreTokens()) {
                try {
                    String strNameValuePair = tokenizerNameValuePair.nextToken();
                    StringTokenizer tokenizerValue = new StringTokenizer(strNameValuePair, "=");
                    String strName = tokenizerValue.nextToken();
                    String strValue = tokenizerValue.nextToken();
                    this.params.put((Object)strName, (Object)strValue);
                }
                catch (Throwable t) {}
            }
        }
        return this;
    }

    public UrlBuilder addParameters(Map newParams) {
        if (newParams == null) {
            return this;
        }
        for (String strName : newParams.keySet()) {
            Object objValue = newParams.get(strName);
            if (objValue == null) continue;
            if (objValue instanceof Object[]) {
                Object[] ar = (Object[])objValue;
                for (int j = 0; j < ar.length; ++j) {
                    Object o = ar[j];
                    this.params.put((Object)strName, (Object)URLEncoder.encode(o.toString()));
                }
                continue;
            }
            this.params.put((Object)strName, (Object)URLEncoder.encode(objValue.toString()));
        }
        return this;
    }

    public UrlBuilder setParameter(String name, String value) {
        this.removeParameter(name);
        return this.addParameter(name, value);
    }

    public UrlBuilder addParameter(String name, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            this.params.put((Object)name, (Object)URLEncoder.encode(value));
        }
        return this;
    }

    public UrlBuilder removeParameter(String name) {
        this.params.remove((Object)name);
        return this;
    }

    public String getParameter(String name) {
        Object o = this.params.get((Object)name);
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return (String)c.iterator().next();
        }
        return null;
    }

    public String toString() {
        StringBuffer queryString = new StringBuffer();
        boolean firstTime = true;
        for (Object o : this.params.keySet()) {
            String name = (String)o;
            Collection collections = (Collection)this.params.get((Object)name);
            if (collections == null || collections.isEmpty()) continue;
            for (Object collection : collections) {
                String value = (String)collection;
                if (StringUtils.isEmpty((String)value)) continue;
                if (firstTime) {
                    firstTime = false;
                } else {
                    queryString.append("&");
                }
                queryString.append(name);
                queryString.append("=");
                queryString.append(value);
            }
        }
        if (queryString.length() > 0) {
            queryString.insert(0, '?');
            queryString.insert(0, this.urlWithNoParams);
            return queryString.toString();
        }
        return this.urlWithNoParams;
    }
}

