/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooStringUtils {
    private static final Logger log = Logger.getLogger(BambooStringUtils.class);
    private static final Pattern INVALID_CHARACTERS_REGEX = Pattern.compile("[^-A-Za-z0-9_:.]");
    private static final char[] XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>', '\\'};
    private static final Pattern hrefPattern = Pattern.compile("a +href *= *\"([\\w\\$\\-\\+\\(\\):/\\.!\\?#]*(&[a-zA-Z])*)*\" *");
    private static final Pattern htmlWhiteListPattern = Pattern.compile("(/?+ *(p|i|b|div) *)|(/ *a *)|( *br */?+)");

    private BambooStringUtils() {
    }

    @NotNull
    public static String forceAlphaNumeric(@Nullable String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuffer sBuf = new StringBuffer();
        for (char aChar : charArray) {
            if (!CharUtils.isAsciiAlphanumeric((char)aChar)) continue;
            sBuf.append(aChar);
        }
        return sBuf.toString();
    }

    public static boolean containsXssRelatedCharacters(@Nullable String string) {
        return string != null && StringUtils.containsAny((String)string, (char[])XSS_RELATED_CHARACTERS);
    }

    @NotNull
    public static String getFirstXssRelatedCharacter(@Nullable String string) {
        if (string == null) {
            return "";
        }
        int unsafeCharIndex = StringUtils.indexOfAny((String)string, (char[])XSS_RELATED_CHARACTERS);
        if (unsafeCharIndex == -1) {
            return "";
        }
        return string.substring(unsafeCharIndex, unsafeCharIndex + 1);
    }

    @NotNull
    public static String forceValidHtmlId(@NotNull String id) {
        return INVALID_CHARACTERS_REGEX.matcher(id).replaceAll("");
    }

    public static final String encodeHtmlWithTagWhiteList(String string) {
        StringTokenizer st = new StringTokenizer(string, "<>", true);
        StringBuilder sb = new StringBuilder();
        String tagContent = null;
        EncoderState state = EncoderState.START;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case START: {
                    if (token.equals("<")) {
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    break;
                }
                case AFTER_LT: {
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        break;
                    }
                    if (token.equals(">")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)">"));
                        state = EncoderState.START;
                        break;
                    }
                    tagContent = token;
                    state = EncoderState.AFTER_TAG_CONTENT;
                    break;
                }
                case AFTER_TAG_CONTENT: {
                    if (token.equals(">") && htmlWhiteListPattern.matcher(tagContent).matches()) {
                        sb.append("<").append(tagContent).append(">");
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals(">") && tagContent.startsWith("a ")) {
                        sb.append(BambooStringUtils.sanitizeLink(tagContent));
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                    sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    state = EncoderState.START;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case AFTER_LT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                break;
            }
            case AFTER_TAG_CONTENT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                sb.append(StringEscapeUtils.escapeHtml(tagContent));
            }
        }
        return sb.toString();
    }

    private static final String sanitizeLink(String string) {
        if (hrefPattern.matcher(string).matches()) {
            return "<" + string + ">";
        }
        return StringEscapeUtils.escapeHtml((String)"<") + StringEscapeUtils.escapeHtml((String)string) + StringEscapeUtils.escapeHtml((String)">");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EncoderState {
        START,
        AFTER_LT,
        AFTER_TAG_CONTENT;

    }
}

