/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.BambooIOUtils;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooFileUtils {
    private static final Logger log = Logger.getLogger(BambooFileUtils.class);

    private BambooFileUtils() {
    }

    public static boolean isDirectoryImportant(File planSourceDirectory) {
        if (planSourceDirectory == null || planSourceDirectory.getAbsolutePath() == null) {
            return false;
        }
        String path = planSourceDirectory.getAbsolutePath();
        return path.equals("/") || path.equals("/tmp") || path.equals("C:") || path.equals("C:\\Windows\\system32") || path.equals("C:\\Windows") || path.equals(System.getProperty("user.home")) || path.equals(new File("").getAbsolutePath());
    }

    public static File createTempDirectory(@NotNull Object client) throws IOException {
        return BambooFileUtils.createTempDirectory(client.getClass().getName());
    }

    public static File createTempDirectory(@NotNull String prefix) throws IOException {
        int MAX_TRIES = 10;
        int tries = 0;
        while (tries < 10) {
            File tempDirectory = File.createTempFile(prefix, null);
            if (tempDirectory.delete() && tempDirectory.mkdir()) {
                return tempDirectory;
            }
            if (tries++ <= 5 || tries >= 10) continue;
            try {
                Thread.sleep(10 + 2 * tries);
            }
            catch (InterruptedException e) {}
        }
        log.warn((Object)"Could not replace temporary file with a directory");
        throw new IOException("Could not replace temporary file with a directory.");
    }

    @NotNull
    public static List<String> splitPathToComponents(@NotNull String path) {
        ArrayList result = Lists.newArrayList();
        File file = new File(path);
        do {
            result.add(0, file.getName());
        } while ((file = file.getParentFile()) != null);
        return result;
    }

    @NotNull
    public static String pathFromComponents(@NotNull String[] pathComponents) {
        File file = new File("");
        for (String pathComponent : pathComponents) {
            file = new File(file, pathComponent);
        }
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(File file, Pattern pattern) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        CharsetDecoder decoder = BambooIOUtils.UTF_8_CHARSET.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, decoder);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            br.close();
        }
        return false;
    }

    public static boolean containsRegex(@NotNull File file, @NotNull String regexToMatch) throws IOException {
        Pattern pattern = Pattern.compile(regexToMatch);
        return BambooFileUtils.contains(file, pattern);
    }
}

