/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BambooDateUtils {
    private static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    private static final String TIME_FORMAT_HH_MM_SS_SSS = "HH:mm:ss.SSS";
    @GuardedBy(value="PORTABLE_DATE_FORMAT")
    private static final SimpleDateFormat PORTABLE_DATE_FORMAT = new SimpleDateFormat("'portable' G yyyy-MM-dd HH:mm:ss.SSS Z", Locale.ENGLISH);
    private static final DateTimeFormatter ISO_TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();

    private BambooDateUtils() {
    }

    public static boolean isWithinDays(Date earlierDate, Date laterDate, long days) {
        long daysDifference = (laterDate.getTime() - earlierDate.getTime()) / 86400000L;
        if (daysDifference < 0L) {
            throw new IllegalArgumentException("LaterDate must be later than the first date");
        }
        return daysDifference < days;
    }

    public static boolean isWithinMillis(@Nullable Date date1, @Nullable Date date2, long millis) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return Math.abs(date2.getTime() - date1.getTime()) <= millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToPortableString(Date date) {
        SimpleDateFormat simpleDateFormat = PORTABLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return PORTABLE_DATE_FORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date portableDateToString(String dateString) throws ParseException {
        SimpleDateFormat simpleDateFormat = PORTABLE_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return PORTABLE_DATE_FORMAT.parse(dateString);
        }
    }

    public static int getMinutesDistanceToNow(Date dateToCompare) {
        Date currentTime = new Date();
        long distance = currentTime.getTime() - dateToCompare.getTime();
        return (int)(distance / 60000L);
    }

    @NotNull
    public static String toIsoTimestampString(@NotNull Date date) {
        return ISO_TIMESTAMP_FORMATTER.print(date.getTime());
    }

    @NotNull
    public static Date fromIsoTimestampString(@NotNull String dateString) {
        return ISO_TIMESTAMP_FORMATTER.parseDateTime(dateString).toDate();
    }
}

