/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.BuildResultCreationException;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildResultsSummaryManager {
    @NotNull
    public Collection<BuildResultsSummary> getAllPendingBuildResultSummaries();

    @NotNull
    public List<ExtendedBuildResultsSummary> getAllBuildResultsSummaries(@NotNull Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getAllBuildResultsSummariesForAgent(@NotNull Long var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getAllFailedResultsSummaries(@NotNull Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLastNFailedResultsSummaries(@NotNull Build var1, int var2);

    @NotNull
    public <T extends BuildResultsSummary> List<T> getLastNBuildResultsSummaries(@NotNull Build var1, int var2);

    @NotNull
    public ExtendedBuildResultsSummary getLastOrNBuildResultsSummary(@NotNull Build var1, @Nullable String var2);

    public BuildResultsSummary getBuildResultsSummaryById(long var1);

    @Nullable
    public ExtendedBuildResultsSummary getBuildResultsSummary(String var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary getBuildResultsSummary(@NotNull PlanResultKey var1);

    public void saveBuildResultsSummary(@NotNull BuildResultsSummary var1);

    @NotNull
    public ExtendedBuildResultsSummary createBuildResultSummary(BuildContext var1) throws BuildResultCreationException;

    @NotNull
    public ExtendedBuildResultsSummary updateBuildSummaryFromBuildResults(BuildContext var1, CurrentlyBuilding var2, BuildResults var3);

    @NotNull
    public ExtendedBuildResultsSummary updateBuildState(@NotNull BuildResultsSummary var1, @NotNull BuildState var2);

    public BuildResultsSummary getFirstBuildSummary(Build var1);

    public ExtendedBuildResultsSummary getLastBuildSummary(Build var1);

    public long getNumberOfResults(Build var1);

    @Nullable
    public ExtendedBuildResultsSummary getBuildResultsSummary(Build var1, int var2);

    public long getAverageBuildTime(@NotNull Build var1, int var2);

    public List getNeighbouringSummaries(Build var1, int var2);

    public void removeBuildResultsSummariesForBuild(@NotNull Build var1);

    @Nullable
    public BuildResultsSummary getBreakingBuild(BuildResultsSummary var1);

    @Nullable
    public BuildResultsSummary getFixingBuild(BuildResultsSummary var1);

    public List<ExtendedBuildResultsSummary> getLatestbuildResultSummaries();

    public List<ExtendedBuildResultsSummary> getLatestFailedBuildResultSummaries();

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummaries(@NotNull BuildResultsSummaryCriteria var1);

    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesForBuild(@NotNull Build var1, @NotNull BuildResultsSummaryCriteria var2);

    public int countBuildResultsSummaries();

    public int countBuildResultsSummaries(@Nullable String var1);

    public void removeBuildResult(Build var1, int var2);

    public void removeArtifacts(Build var1, int var2);

    public void removeBuildLogs(Build var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildSummary(@NotNull String var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLatestSummariesForAgent(@NotNull Long var1, @NotNull Date var2);

    @NotNull
    public List<ExtendedBuildResultsSummary> getLatestSummariesForAgent(@NotNull Long var1, int var2);

    public ExtendedBuildResultsSummary getLastBuildSummary(String var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByJiraIssues(@Nullable List<String> var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByProjectKey(@Nullable String var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuildResults(@NotNull List<BuildResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForBuild(@NotNull Build var1);

    @Nullable
    public ExtendedBuildResultsSummary getLastBuildForAgent(@NotNull String var1, @NotNull Long var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildForAgent(@NotNull String var1, @NotNull Long var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastBuildForImageConfiguration(@NotNull String var1, @NotNull ElasticImageConfiguration var2);

    @Nullable
    public ExtendedBuildResultsSummary getLastSuccessfulBuildForImageConfiguration(@NotNull String var1, @NotNull ElasticImageConfiguration var2);

    public int countBuildResultsSummariesForAgent(@NotNull BuildAgent var1);

    public int countFailedBuildResultsSummariesForAgent(@NotNull BuildAgent var1);

    @Nullable
    public ExtendedBuildResultsSummary findLastSuccessfulBuildResultBefore(@NotNull Build var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findLastFailingBuildResultBefore(@NotNull Build var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findFirstFailedBuildResultBetween(@NotNull Build var1, int var2, int var3);

    @Nullable
    public ExtendedBuildResultsSummary findLastBuildResultBefore(@NotNull Build var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findLastBuildResultBefore(@NotNull String var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findFirstFailedBuildResultAfter(@NotNull String var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findFirstSuccessfulBuildResultAfter(@NotNull String var1, int var2);
}

