/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.persistence.BambooObjectDao;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildResultsSummaryDao
extends BambooObjectDao {
    @NotNull
    public Collection<BuildResultsSummary> getAllPendingBuildResultSummaries();

    @Nullable
    public ExtendedBuildResultsSummary getBuildResultsSummaryByBuildKeyAndBuildNumber(String var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary getBuildResultsSummary(@NotNull PlanResultKey var1);

    @Nullable
    public BuildResultsSummary getFirstBuildSummary(Build var1);

    @Nullable
    public ExtendedBuildResultsSummary getLastBuildSummary(String var1);

    public long getNumberOfResults(Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> getNeighbouringSummaries(Build var1, int var2);

    @Nullable
    public BuildResultsSummary getBreakingBuild(BuildResultsSummary var1);

    @Nullable
    public BuildResultsSummary getFixingBuild(BuildResultsSummary var1);

    @NotNull
    public <T extends BuildResultsSummary> List<T> findBuildResultsSummaries(@NotNull BuildResultsSummaryCriteria var1);

    public int countBuildResultsSummaries(long var1, @Nullable BuildState var3);

    public int countBuildResultsSummaries(@Nullable String var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByJiraIssues(@Nullable List<String> var1);

    public void removeBuildResultsSummary(BuildResultsSummary var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildResultsSummariesByProjectKey(@Nullable String var1);

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForBuildResults(@NotNull List<BuildResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> getJiraIssuesForBuild(@NotNull Build var1);

    @NotNull
    public List<ExtendedBuildResultsSummary> findBuildsForImageConfiguration(String var1, ElasticImageConfiguration var2, @Nullable BuildState var3, int var4);

    @Nullable
    public ExtendedBuildResultsSummary findLastBuildResultBefore(@NotNull String var1, int var2);

    @Nullable
    public ExtendedBuildResultsSummary findFirstBuildResultWithBuildStateAfter(@NotNull String var1, int var2, @NotNull BuildState var3);

    public ExtendedBuildResultsSummary findLastBuildResultWithBuildStateBefore(@NotNull String var1, int var2, @NotNull BuildState var3);

    @Nullable
    public ExtendedBuildResultsSummary findFirstBuildResultWithBuildStateBetween(@NotNull String var1, int var2, int var3, @NotNull BuildState var4);

    public List<Pair<ArtifactLink, BuildResultsSummary>> findBuildResultsWithArtifacts(String var1);

    public long scrollBuildResultSummariesForExport(@NotNull String var1, @NotNull Function<ExtendedBuildResultsSummary, Void> var2);

    public long scrollJiraIssuesForExport(@NotNull Function<LinkedJiraIssue, Void> var1);
}

