/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.project;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanVisitor;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ExtendedBuildResultsSummary;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProject
extends BambooEntityObject
implements Project {
    private String key;
    protected String name;
    protected String description;
    private List labellings;
    private List<Plan> plans;

    public DefaultProject(String key, String name, String description) {
        this.key = key;
        this.name = name;
        this.description = description;
    }

    public DefaultProject() {
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(@NotNull String key) {
        this.key = key;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Override
    @NotNull
    public List<Plan> getPlans() {
        if (this.plans == null) {
            return Collections.emptyList();
        }
        return this.plans;
    }

    @Override
    @NotNull
    public List<Chain> getChains() {
        if (this.plans == null) {
            return Collections.emptyList();
        }
        final ArrayList chains = Lists.newArrayList();
        for (Plan plan : this.plans) {
            plan.accept(new PlanVisitor(){

                public void visitBuild(Build build) {
                }

                public void visitChain(Chain chain) {
                    chains.add(chain);
                }
            });
        }
        return chains;
    }

    @Override
    @NotNull
    public List<Build> getBuilds() {
        if (this.plans == null) {
            return Collections.emptyList();
        }
        final ArrayList builds = Lists.newArrayList();
        for (Plan plan : this.plans) {
            plan.accept(new PlanVisitor(){

                public void visitBuild(Build build) {
                    builds.add(build);
                }

                public void visitChain(Chain chain) {
                }
            });
        }
        return builds;
    }

    public String getProjectSummary() {
        return DefaultProject.getProjectSummaryForPlans(this.getBuilds());
    }

    public static String getProjectSummaryForPlans(Collection<Build> builds) {
        int total = 0;
        int failed = 0;
        for (Build build : builds) {
            ExtendedBuildResultsSummary summary;
            if (build.isSuspendedFromBuilding() || (summary = build.getLatestBuildSummary()) == null) continue;
            if (BuildState.FAILED.equals((Object)summary.getBuildState())) {
                ++failed;
            }
            ++total;
        }
        if (failed > 0) {
            if (total == 1) {
                return "1 failed build plan";
            }
            return failed + " of " + total + " build plans failed";
        }
        if (total == 1) {
            return total + " successful build plan";
        }
        return total + " successful build plans";
    }

    @Override
    public String getCurrentStatus() {
        return DefaultProject.getCurrentStatusFromBuilds(this.getBuilds());
    }

    public static String getCurrentStatusFromBuilds(Collection<Build> builds) {
        for (Build build : builds) {
            if (build.isSuspendedFromBuilding()) continue;
            String currentStatus = build.getCurrentStatus();
            if (currentStatus.equals("current")) {
                return "current";
            }
            if (!currentStatus.equals("fail")) continue;
            return "fail";
        }
        return "success";
    }

    public void setPlans(List<Plan> plans) {
        this.plans = plans;
    }

    @Override
    public List<Labelling> getLabellings() {
        return this.labellings;
    }

    @Override
    public List<Labelling> getRelatedLabellings() {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getLabellings(), (Predicate)new Predicate<Labelling>(){

            public boolean apply(Labelling input) {
                return input.getPlan() == null && input.getBuildResultsSummary() == null;
            }
        }));
    }

    @Override
    public void setLabellings(List<Labelling> labellings) {
        this.labellings = labellings;
    }

    public int hashCode() {
        return new HashCodeBuilder(89, 11).append((Object)this.getKey()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultProject)) {
            return false;
        }
        DefaultProject rhs = (DefaultProject)o;
        return new EqualsBuilder().append((Object)this.getKey(), (Object)rhs.getKey()).isEquals();
    }

    public int compareTo(Object obj) {
        DefaultProject o = (DefaultProject)obj;
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).toComparison();
    }
}

