/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.PlanKey;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public final class PlanResultKey
implements Serializable {
    private final PlanKey planKey;
    private final int buildNumber;

    PlanResultKey(@NotNull PlanKey planKey, int buildNumber) {
        this.planKey = planKey;
        this.buildNumber = buildNumber;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public String getKey() {
        return this.planKey.getKey() + "-" + this.getBuildNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanResultKey)) {
            return false;
        }
        PlanResultKey resultKey = (PlanResultKey)o;
        return new EqualsBuilder().append(this.buildNumber, resultKey.buildNumber).append((Object)this.planKey, (Object)resultKey.planKey).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(this.planKey.hashCode(), 31).append(this.buildNumber).hashCode();
    }

    public String toString() {
        return this.getKey();
    }
}

