/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import org.apache.commons.lang.StringUtils;

public final class PlanKeys {
    private static final char SEP = '-';

    public static PlanKey getPlanKey(String planKey) {
        String[] parts = StringUtils.split((String)planKey, (char)'-');
        if (parts.length > 3 || parts.length < 2) {
            throw new IllegalArgumentException("Could not parse key '" + planKey + "'");
        }
        return new PlanKey(parts[0] + '-' + parts[1]);
    }

    public static PlanResultKey getPlanResultKey(String planResultKey) {
        return PlanKeys.parse(PlanKeys.getPlanKey(planResultKey), planResultKey);
    }

    public static PlanResultKey getPlanResultKey(String planKey, int buildNumber) {
        PlanKey key = PlanKeys.getPlanKey(planKey);
        return new PlanResultKey(key, buildNumber);
    }

    private static PlanResultKey parse(PlanKey planKey, String key) {
        String[] parts = StringUtils.split((String)key, (char)'-');
        if (parts.length == 3) {
            Integer buildNumber;
            String numberPart = parts[2];
            try {
                buildNumber = Integer.parseInt(numberPart);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse build number part of key '" + key + "'");
            }
            return new PlanResultKey(planKey, buildNumber);
        }
        throw new IllegalArgumentException("Could not parse key '" + key + "'");
    }
}

