/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.LabelPathMap;
import com.atlassian.bamboo.utils.JavaVirtualMachineDetector;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class Jdk
extends LabelPathMap {
    private static final Logger log = Logger.getLogger(Jdk.class);
    public static final String CAPABILITY_JDK_TYPE = "jdk";
    public static final String CAPABILITY_JDK_PREFIX = "system.jdk";

    public Jdk(String label, String homeDirectory) {
        super(label, homeDirectory);
    }

    public boolean isValid() {
        try {
            String[] files = null;
            File testOriginalDataDir = new File(this.getHomeDirectory(), "bin/");
            if (testOriginalDataDir.exists()) {
                files = testOriginalDataDir.list(new FilenameFilter(){

                    public boolean accept(File directory, String filename) {
                        return filename.equals("java") || filename.equals("java.exe");
                    }
                });
            }
            return files != null && files.length > 0 && this.isAJdk();
        }
        catch (Exception e) {
            log.info((Object)"Failed", (Throwable)e);
            return false;
        }
    }

    public boolean isAJdk() {
        JavaVirtualMachineDetector detector = new JavaVirtualMachineDetector(SystemUtils.IS_OS_MAC_OSX);
        File javaHome = new File(this.getHomeDirectory());
        return detector.containsToolsJar(javaHome) && detector.containsJavac(javaHome);
    }

    public String getUiSwitchName() {
        return "JDK";
    }

    public static Jdk discoverDefaultJdk() {
        String javaVersion = SystemUtils.JAVA_VERSION;
        Jdk jdk = new Jdk(javaVersion, SystemUtils.JAVA_HOME);
        if (jdk.isValid()) {
            return jdk;
        }
        jdk = new Jdk(javaVersion, SystemUtils.getJavaHome().getParent());
        if (jdk.isValid()) {
            return jdk;
        }
        javaVersion = javaVersion + " (JRE)";
        return new Jdk(javaVersion, SystemUtils.JAVA_HOME);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

