/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.atlassian.bamboo.builder.BuildState;
import java.util.EnumMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeltaState {
    NONE,
    PASSING,
    FAILING,
    BROKEN,
    FIXED;

    private static final Logger log;
    private static final Map<BuildState, Map<BuildState, DeltaState>> BUILD_STATE_TRANSITIONS;

    public static DeltaState determineDeltaState(BuildState lastBuildState, BuildState thisBuildState) {
        if (lastBuildState != null && thisBuildState != null) {
            return BUILD_STATE_TRANSITIONS.get((Object)lastBuildState).get((Object)thisBuildState);
        }
        return NONE;
    }

    public static DeltaState getInstance(String deltaState) {
        if (deltaState != null) {
            try {
                return DeltaState.valueOf(deltaState);
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
        return NONE;
    }

    static {
        log = Logger.getLogger(DeltaState.class);
        BUILD_STATE_TRANSITIONS = new EnumMap<BuildState, Map<BuildState, DeltaState>>(BuildState.class){
            {
                for (BuildState buildState : BuildState.values()) {
                    EnumMap<BuildState, DeltaState> map = new EnumMap<BuildState, DeltaState>(BuildState.class);
                    for (BuildState bs : BuildState.values()) {
                        map.put(bs, NONE);
                    }
                    this.put(buildState, map);
                }
                ((Map)this.get((Object)BuildState.SUCCESS)).put(BuildState.SUCCESS, PASSING);
                ((Map)this.get((Object)BuildState.SUCCESS)).put(BuildState.FAILED, BROKEN);
                ((Map)this.get((Object)BuildState.FAILED)).put(BuildState.SUCCESS, FIXED);
                ((Map)this.get((Object)BuildState.FAILED)).put(BuildState.FAILED, FAILING);
                ((Map)this.get((Object)BuildState.NOT_BUILT)).put(BuildState.SUCCESS, NONE);
                ((Map)this.get((Object)BuildState.NOT_BUILT)).put(BuildState.FAILED, NONE);
            }
        };
    }
}

