/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BuildState {
    PENDING("Pending"),
    SUCCESS("Successful"),
    FAILED("Failed"),
    NOT_BUILT("Not Built");

    private static final TreeMap<String, BuildState> BUILD_STATE_MAPPING;
    private final String state;

    private BuildState(String state) {
        this.state = state;
    }

    public static BuildState getInstance(String state) {
        BuildState buildState = BUILD_STATE_MAPPING.get(state);
        if (buildState == null) {
            throw new IllegalArgumentException("There is no BuildState called '" + state + "'");
        }
        return buildState;
    }

    public String toString() {
        return this.state;
    }

    static {
        BUILD_STATE_MAPPING = new TreeMap<String, BuildState>(String.CASE_INSENSITIVE_ORDER){
            {
                for (BuildState buildState : BuildState.values()) {
                    this.put(buildState.state, buildState);
                }
            }
        };
    }
}

