/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.statistics;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class FailurePeriod {
    private static final Logger log = Logger.getLogger(FailurePeriod.class);
    private List alsoFailingInBuilds = new ArrayList();
    private BuildResultsSummary fixingBuild;
    private BuildResultsSummary breakingBuild;
    private BuildResultsSummary removedInBuild;
    private final Build build;

    public FailurePeriod(Build build) {
        this.build = build;
    }

    public boolean includesBuild(Integer buildNumber) {
        if (buildNumber == null) {
            return false;
        }
        if (buildNumber.equals(new Integer(this.breakingBuild.getBuildNumber()))) {
            return true;
        }
        for (BuildResultsSummary buildResultsSummary : this.alsoFailingInBuilds) {
            if (!buildNumber.equals(new Integer(buildResultsSummary.getBuildNumber()))) continue;
            return true;
        }
        return false;
    }

    public long getElapsedTime() {
        if (this.getBreakingBuild() == null) {
            return 0L;
        }
        long start = this.getBreakingBuild().getBuildDate().getTime();
        long end = this.getFixingBuild() != null ? this.getFixingBuild().getBuildDate().getTime() : (this.getRemovedInBuild() != null ? this.getRemovedInBuild().getBuildDate().getTime() : System.currentTimeMillis());
        return end - start;
    }

    public int getElapsedBuilds() {
        BuildResultsSummary fixingBuild = this.getFixingBuild();
        if (fixingBuild != null) {
            return fixingBuild.getBuildNumber() - this.getBreakingBuild().getBuildNumber();
        }
        BuildResultsSummary removedInBuild = this.getRemovedInBuild();
        if (removedInBuild != null) {
            return removedInBuild.getBuildNumber() - this.getBreakingBuild().getBuildNumber();
        }
        return this.build.getLastBuildNumber() - this.getBreakingBuild().getBuildNumber();
    }

    public void addFailingBuild(BuildResultsSummary build) {
        if (this.breakingBuild == null) {
            this.breakingBuild = build;
        } else {
            this.alsoFailingInBuilds.add(build);
        }
    }

    public BuildResultsSummary getBreakingBuild() {
        return this.breakingBuild;
    }

    public void setBreakingBuild(BuildResultsSummary breakingBuild) {
        this.breakingBuild = breakingBuild;
    }

    public List getAlsoFailingInBuilds() {
        return this.alsoFailingInBuilds;
    }

    public void setAlsoFailingInBuilds(List alsoFailingInBuilds) {
        this.alsoFailingInBuilds = alsoFailingInBuilds;
    }

    public BuildResultsSummary getFixingBuild() {
        return this.fixingBuild;
    }

    public void setFixingBuild(BuildResultsSummary fixingBuild) {
        this.fixingBuild = fixingBuild;
    }

    public BuildResultsSummary getRemovedInBuild() {
        return this.removedInBuild;
    }

    public void setRemovedInBuild(BuildResultsSummary removedInBuild) {
        this.removedInBuild = removedInBuild;
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 79).append((Object)this.getBreakingBuild()).append((Object)this.getFixingBuild()).append((Object)this.getRemovedInBuild()).append((Object)this.getAlsoFailingInBuilds()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FailurePeriod)) {
            return false;
        }
        FailurePeriod rhs = (FailurePeriod)o;
        return new EqualsBuilder().append((Object)this.getBreakingBuild(), (Object)rhs.getBreakingBuild()).append((Object)this.getFixingBuild(), (Object)rhs.getFixingBuild()).append((Object)this.getRemovedInBuild(), (Object)rhs.getRemovedInBuild()).append((Object)this.getAlsoFailingInBuilds(), (Object)rhs.getAlsoFailingInBuilds()).isEquals();
    }

    public int compareTo(Object obj) {
        FailurePeriod o = (FailurePeriod)obj;
        return new CompareToBuilder().append(this.getBreakingBuild().getBuildNumber(), o.getBreakingBuild().getBuildNumber()).toComparison();
    }
}

