/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.Build;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.security.acegi.acls.HibernateAcl;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BuildManager {
    @Nullable
    public Build getBuildByKey(String var1);

    public Build getBuildById(long var1);

    public Collection<Build> getAllBuilds();

    public Collection<Build> getAllBuildsForRead();

    public Collection<Build> retreiveAllBuilds();

    public Collection<Build> getAllBuildsForEdit();

    public Collection<Build> getAllBuildsForClone();

    public Collection<Build> getBuildsForDeletion();

    public Collection<Build> getFavouriteBuildsForRead(User var1);

    @NotNull
    public Set<Build> filterFavouritedBuilds(@NotNull Collection<Build> var1, @NotNull User var2);

    @NotNull
    public Collection<Build> getFavouriteBuildsByProjectForRead(Project var1, User var2);

    public Collection<Build> getBuildsByProjectForRead(Project var1);

    public boolean isExistingBuildName(String var1, String var2);

    public boolean isExistingBuildKey(String var1, String var2);

    public boolean exists(String var1);

    public boolean isPlanCreationAllowed();

    public boolean isBuildingSuspended();

    public boolean recheckBuildingSuspended();

    public int getPlanCount();

    public void createBuild(Build var1, BuildConfiguration var2, HibernateAcl var3) throws PlanCreationDeniedException;

    public void saveBuild(Build var1);

    public void saveSuspendBuild(String var1, boolean var2);

    public void deleteBuild(@NotNull String var1);

    public void addBuildResults(Build var1, BuildResults var2);

    @Nullable
    public BuildResults getBuildResults(Build var1, Integer var2);

    public BuildResults getBuildResults(String var1, Integer var2);

    public Build getBuildByProjectAndName(String var1, String var2);

    public void updateNames(String var1, String var2, Build var3);

    public void updateNamesAndDescription(String var1, String var2, @Nullable String var3, Build var4);

    public boolean isAllowBuilding(@NotNull String var1);

    @NotNull
    public Map<Project, Collection<Build>> getProjectBuilds(boolean var1);

    public String updateVcsRevisionKey(@NotNull BuildContext var1);

    @Nullable
    public String revertVcsRevisionKey(@NotNull String var1, @NotNull String var2, @Nullable String var3);
}

