/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import java.io.Serializable;

public class AutomaticInstanceManagementConfig
implements Serializable {
    public static final String CUSTOM = "Custom";
    static final int ELASTIC_BUILDS_IN_QUEUE_THRESHOLD = 3;
    static final int TOTAL_BUILDS_IN_QUEUE_THRESHOLD = 5;
    static final long AVERAGE_TIME_IN_QUEUE_THRESHOLD = 300000L;
    static final int MAX_NUM_ELASTIC_INSTANCES_TO_START = 2;
    static final long ELASTIC_AGENT_IDLE_THRESHOLD = 600000L;
    public static final AutomaticInstanceManagementConfig DEFAULT_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Default", true);
    public static final AutomaticInstanceManagementConfig DISABLED_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Disabled", false);
    public static final AutomaticInstanceManagementConfig CUSTOM_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Custom", true);
    public static final AutomaticInstanceManagementConfig PASSIVE_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Passive", true, 600000L, 6, 10, 1, 600000L);
    public static final AutomaticInstanceManagementConfig AGGRESSIVE_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Aggressive", true, 150000L, 1, 2, 4, 600000L);
    private long averageTimeInQueueThreshold = 300000L;
    private int elasticBuildsInQueueThreshold = 3;
    private int totalBuildInQueueThreshold = 5;
    private int maxElasticInstancesToStartAtOnce = 2;
    private long instanceIdleTimeThreshold = 600000L;
    private final boolean automaticInstanceManagementEnabled;
    private final String configurationName;

    private AutomaticInstanceManagementConfig(String configName, boolean automaticInstanceManagementEnabled) {
        this.configurationName = configName;
        this.automaticInstanceManagementEnabled = automaticInstanceManagementEnabled;
    }

    private AutomaticInstanceManagementConfig(String configurationName, boolean automaticInstanceManagementEnabled, long averageTimeInQueueThreshold, int elasticBuildsInQueueThreshold, int totalBuildInQueueThreshold, int maxElasticInstancesToStartAtOnce, long instanceIdleTimeThreshold) {
        this(configurationName, automaticInstanceManagementEnabled);
        this.averageTimeInQueueThreshold = averageTimeInQueueThreshold;
        this.elasticBuildsInQueueThreshold = elasticBuildsInQueueThreshold;
        this.totalBuildInQueueThreshold = totalBuildInQueueThreshold;
        this.maxElasticInstancesToStartAtOnce = maxElasticInstancesToStartAtOnce;
        this.instanceIdleTimeThreshold = instanceIdleTimeThreshold;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean isAutomaticInstanceManagementEnabled() {
        return this.automaticInstanceManagementEnabled;
    }

    private void assertChangingAllowed() {
        if (!CUSTOM.equals(this.configurationName)) {
            throw new IllegalStateException("Changing parameters is only allowed for 'Custom' configuration");
        }
    }

    public long getAverageTimeInQueueThreshold() {
        return this.averageTimeInQueueThreshold;
    }

    public void setAverageTimeInQueueThreshold(long averageTimeInQueueThreshold) {
        this.assertChangingAllowed();
        this.averageTimeInQueueThreshold = averageTimeInQueueThreshold;
    }

    public int getElasticBuildsInQueueThreshold() {
        return this.elasticBuildsInQueueThreshold;
    }

    public void setElasticBuildsInQueueThreshold(int elasticBuildsInQueueThreshold) {
        this.assertChangingAllowed();
        this.elasticBuildsInQueueThreshold = elasticBuildsInQueueThreshold;
    }

    public int getTotalBuildInQueueThreshold() {
        return this.totalBuildInQueueThreshold;
    }

    public void setTotalBuildInQueueThreshold(int totalBuildInQueueThreshold) {
        this.assertChangingAllowed();
        this.totalBuildInQueueThreshold = totalBuildInQueueThreshold;
    }

    public int getMaxElasticInstancesToStartAtOnce() {
        return this.maxElasticInstancesToStartAtOnce;
    }

    public void setMaxElasticInstancesToStartAtOnce(int maxElasticInstancesToStartAtOnce) {
        this.assertChangingAllowed();
        this.maxElasticInstancesToStartAtOnce = maxElasticInstancesToStartAtOnce;
    }

    public long getInstanceIdleTimeThreshold() {
        return this.instanceIdleTimeThreshold;
    }

    public void setInstanceIdleTimeThreshold(long instanceIdleTimeThreshold) {
        this.assertChangingAllowed();
        this.instanceIdleTimeThreshold = instanceIdleTimeThreshold;
    }
}

