/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ActiveInstanceAdjustmentType {
    EQUALS(1L){

        public int getAdjustmentNumber(int from, int to) {
            return to - from;
        }
    }
    ,
    AT_LEAST(2L){

        public int getAdjustmentNumber(int from, int to) {
            if (from >= to) {
                return 0;
            }
            return to - from;
        }
    }
    ,
    NO_MORE_THAN(3L){

        public int getAdjustmentNumber(int from, int to) {
            if (to >= from) {
                return 0;
            }
            return to - from;
        }
    };

    private static final Logger log;
    private static final Map<Long, ActiveInstanceAdjustmentType> ACTIVE_INSTANCE_COMPARISONS;
    private final long databaseId;

    private ActiveInstanceAdjustmentType(long databaseId) {
        this.databaseId = databaseId;
    }

    public long getDatabaseId() {
        return this.databaseId;
    }

    public abstract int getAdjustmentNumber(int var1, int var2);

    @Nullable
    public static ActiveInstanceAdjustmentType getActiveInstanceAdjustmentType(long databaseId) {
        ActiveInstanceAdjustmentType activeInstanceAdjustmentType = ACTIVE_INSTANCE_COMPARISONS.get(databaseId);
        if (activeInstanceAdjustmentType == null) {
            log.warn((Object)("Unable to find ActiveInstanceAdjustmentType with id: " + databaseId));
            return null;
        }
        return activeInstanceAdjustmentType;
    }

    static {
        log = Logger.getLogger(ActiveInstanceAdjustmentType.class);
        ActiveInstanceAdjustmentType[] activeInstanceAdjustmentTypes = ActiveInstanceAdjustmentType.values();
        ACTIVE_INSTANCE_COMPARISONS = new HashMap<Long, ActiveInstanceAdjustmentType>(activeInstanceAdjustmentTypes.length);
        for (ActiveInstanceAdjustmentType activeInstanceAdjustmentType : activeInstanceAdjustmentTypes) {
            ACTIVE_INSTANCE_COMPARISONS.put(activeInstanceAdjustmentType.getDatabaseId(), activeInstanceAdjustmentType);
        }
    }
}

