/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.ww2.actions.build.admin.create;

import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.CustomizedXMLConfiguration;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.log4j.Logger;

public class BuildConfiguration
extends CombinedConfiguration {
    private static final Logger log = Logger.getLogger(BuildConfiguration.class);
    private boolean overridden = false;
    private static final String PROJECT_CONFIG_KEY = "project";

    public BuildConfiguration() {
        this.init((HierarchicalConfiguration)new CustomizedXMLConfiguration());
    }

    public BuildConfiguration(HierarchicalConfiguration configuration) {
        this.init(configuration);
    }

    public BuildConfiguration(String xmlData) {
        XMLConfiguration xmlConfiguration = ConfigUtils.getXmlConfigFromXmlString(xmlData);
        this.init((HierarchicalConfiguration)xmlConfiguration);
    }

    private void init(HierarchicalConfiguration configuration) {
        OverrideCombiner overrideCombiner = new OverrideCombiner();
        overrideCombiner.addListNode("artifact");
        overrideCombiner.addListNode("entry");
        this.setNodeCombiner((NodeCombiner)overrideCombiner);
        configuration.setDelimiterParsingDisabled(true);
        this.addConfiguration((AbstractConfiguration)configuration, PROJECT_CONFIG_KEY);
    }

    public boolean getBoolean(String key) {
        try {
            return super.getBoolean(key);
        }
        catch (NoSuchElementException e) {
            log.debug((Object)("Key '" + key + "' returned no value. false being returned"));
            return false;
        }
    }

    public int getInt(String key) {
        try {
            return super.getInt(key);
        }
        catch (NoSuchElementException e) {
            log.info((Object)("Key '" + key + "' returned no value. -1 being returned"));
            return -1;
        }
    }

    public void setProperty(String key, Object value) {
        this.getProjectConfig().setProperty(key, value);
    }

    public void addProperty(String key, Object obj) {
        this.getProjectConfig().addProperty(key, obj);
    }

    public void clearTree(String key) {
        this.getProjectConfig().clearTree(key);
    }

    public void clearProperty(String key) {
        this.getProjectConfig().clearProperty(key);
    }

    public XMLConfiguration getProjectConfig() {
        return (XMLConfiguration)this.getConfiguration(PROJECT_CONFIG_KEY);
    }

    public String asXml() {
        XMLConfiguration configuration = this.getProjectConfig();
        return ConfigUtils.asXmlString(configuration);
    }
}

