/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.build.Build;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DependencyBlockingStrategy {
    None("none"),
    DontBuildIfParentInQueue("dont_build_if_parent_in_queue"),
    BuildParentIfChangesDetected("dont_build_if_parent_in_queue_or_has_changes");

    public static final String DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY = "custom.dependencies.trigger.remote.strategy";
    private static final String I18N_PREFIX = "build.dependency.strategy.";
    private final String value;

    private DependencyBlockingStrategy(String value) {
        this.value = value;
    }

    @Nullable
    public static DependencyBlockingStrategy getStrategy(@NotNull Build build) {
        Map<String, String> configuration = build.getBuildDefinition().getCustomConfiguration();
        if (configuration == null) {
            return null;
        }
        String value = configuration.get(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY);
        return DependencyBlockingStrategy.getByValue(value);
    }

    public static void setStrategy(DependencyBlockingStrategy strategy, @NotNull Build build) {
        Map<String, String> configuration = build.getBuildDefinition().getCustomConfiguration();
        if (configuration != null) {
            configuration.put(DEPENDENCY_BLOCKING_STRATEGY_CONFIG_KEY, strategy.value);
        }
    }

    public static DependencyBlockingStrategy getByValue(String value) {
        if (DependencyBlockingStrategy.DontBuildIfParentInQueue.value.equals(value)) {
            return DontBuildIfParentInQueue;
        }
        if (DependencyBlockingStrategy.BuildParentIfChangesDetected.value.equals(value)) {
            return BuildParentIfChangesDetected;
        }
        return None;
    }

    public String getI18nKey() {
        return I18N_PREFIX + this.getValue();
    }

    public String getValue() {
        return this.value;
    }
}

