/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    private static final Logger log = Logger.getLogger(CollectionUtils.class);
    private static final String listItemPattern = "\\[[^\\[\\]]*\\]";

    @NotNull
    public static List<String> stringToCollection(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        Pattern pattern = Pattern.compile(listItemPattern);
        Matcher matcher = pattern.matcher(s);
        ArrayList toReturn = Lists.newArrayList();
        int foundUpTo = 0;
        while (matcher.find(foundUpTo)) {
            String item = matcher.group();
            item = StringUtils.replace((String)item, (String)"[", (String)"");
            item = StringUtils.replace((String)item, (String)"]", (String)"");
            toReturn.add(item);
            foundUpTo = matcher.end();
        }
        return toReturn;
    }

    @NotNull
    public static List<String> stringArrayToList(@Nullable String[] s) {
        if (s == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])s);
    }

    @Nullable
    public static <T> List<T> removeDuplicates(@Nullable List<T> input) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(input)) {
            return input;
        }
        HashSet set = Sets.newHashSet(input);
        return Lists.newArrayList((Iterable)set);
    }

    @Nullable
    public static <T extends Comparable<? super T>> List<T> removeDuplicatesAndSort(List<T> input, Comparator<? super T> c) {
        List<T> output = CollectionUtils.removeDuplicates(input);
        if (output != null) {
            if (c != null) {
                Collections.sort(output, c);
            } else {
                Collections.sort(output);
            }
        }
        return output;
    }

    @Nullable
    public static List<String> convertToList(@Nullable String s) {
        if (s != null) {
            String[] strings = s.split(",");
            ArrayList list = Lists.newArrayListWithCapacity((int)strings.length);
            for (String s1 : strings) {
                if (!StringUtils.isNotBlank((String)s1)) continue;
                list.add(s1.trim());
            }
            return list;
        }
        return null;
    }

    public static <T> boolean isEmpty(@Nullable T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(@Nullable T[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    @NotNull
    public static <T> List<T> subtract(@NotNull Collection<T> a, @NotNull Collection<T> b) {
        ArrayList result = Lists.newArrayList(a);
        result.removeAll(b);
        return result;
    }
}

