/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.util.regex.Pattern;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooStringUtils {
    private static final Logger log = Logger.getLogger(BambooStringUtils.class);
    private static final char[] UNSAFE_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>', '\\'};
    private static final Pattern INVALID_CHARACTERS_REGEX = Pattern.compile("[^-A-Za-z0-9_:.]");

    @NotNull
    public static String forceAlphaNumeric(@Nullable String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuffer sBuf = new StringBuffer();
        for (char aChar : charArray) {
            if (!CharUtils.isAsciiAlphanumeric((char)aChar)) continue;
            sBuf.append(aChar);
        }
        return sBuf.toString();
    }

    public static boolean containsUnsafeCharacters(@Nullable String string) {
        return string != null && StringUtils.containsAny((String)string, (char[])UNSAFE_CHARACTERS);
    }

    @NotNull
    public static String getFirstUnsafeCharacter(@Nullable String string) {
        if (string == null) {
            return "";
        }
        int unsafeCharIndex = StringUtils.indexOfAny((String)string, (char[])UNSAFE_CHARACTERS);
        if (unsafeCharIndex == -1) {
            return "";
        }
        return string.substring(unsafeCharIndex, unsafeCharIndex + 1);
    }

    @NotNull
    public static String forceValidHtmlId(@NotNull String id) {
        return INVALID_CHARACTERS_REGEX.matcher(id).replaceAll("");
    }
}

