/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooFileUtils {
    private static final Logger log = Logger.getLogger(BambooFileUtils.class);

    public static File createTempDirectory(@NotNull Object client) throws IOException {
        return BambooFileUtils.createTempDirectory(client.getClass().getName());
    }

    public static File createTempDirectory(@NotNull String prefix) throws IOException {
        int MAX_TRIES = 10;
        int tries = 0;
        while (tries < 10) {
            File tempDirectory = File.createTempFile(prefix, null);
            if (tempDirectory.delete() && tempDirectory.mkdir()) {
                return tempDirectory;
            }
            if (tries++ <= 5 || tries >= 10) continue;
            try {
                Thread.sleep(10 + 2 * tries);
            }
            catch (InterruptedException e) {}
        }
        log.warn((Object)"Could not replace temporary file with a directory");
        throw new IOException("Could not replace temporary file with a directory.");
    }
}

